package com.zoyi.channel.plugin.android.activity.chat.type;

/**
 * Created by mika on 2016. 12. 8..
 */
public enum MessageType {
  ACTION_MESSAGE(0),
  DATE(5),
  NEW_MESSAGE_DIVIDER(6),
  SENDING(7),
  FETCH_FAILED(9),
  RESOLVE(11),
  CLOSE(12),
  LOG(13),
  TYPING(14),

  GUEST_TEXT_MESSAGE(15),
  GUEST_WEB_MESSAGE(16),
  GUEST_IMAGE_MESSAGE(17),
  GUEST_FILE_MESSAGE(18),
  MANAGER_TEXT_MESSAGE(19),
  MANAGER_WEB_MESSAGE(20),
  MANAGER_IMAGE_MESSAGE(21),
  MANAGER_FILE_MESSAGE(22),
  BOT_TEXT_MESSAGE(23),
  BOT_WEB_MESSAGE(24),
  BOT_IMAGE_MESSAGE(25),
  BOT_FILE_MESSAGE(26),
  PROFILE_BOT_MESSAGE(30),
  FORM_MESSAGE(31),

  WELCOME_MESSAGE(99),

  UNKNOWN(100);

  private final int value;
  MessageType(int value) {
    this.value = value;
  }

  public int toInt() {
    return value;
  }

  public static MessageType fromId(int id) {
    for (MessageType type : MessageType.values()) {
      if (type.toInt() == id) {
        return type;
      }
    }
    return UNKNOWN;
  }
}
