/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.observers.Subscribers;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.SerialSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnSubscribeDelaySubscriptionOther<T, U>
implements Observable.OnSubscribe<T> {
    final Observable<? extends T> main;
    final Observable<U> other;

    public OnSubscribeDelaySubscriptionOther(Observable<? extends T> main, Observable<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void call(Subscriber<? super T> t) {
        final SerialSubscription serial = new SerialSubscription();
        t.add(serial);
        final Subscriber<? super T> child = Subscribers.wrap(t);
        Subscriber otherSubscriber = new Subscriber<U>(){
            boolean done;

            @Override
            public void onNext(U t) {
                this.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    RxJavaHooks.onError(e);
                    return;
                }
                this.done = true;
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                serial.set(Subscriptions.unsubscribed());
                OnSubscribeDelaySubscriptionOther.this.main.unsafeSubscribe(child);
            }
        };
        serial.set(otherSubscriber);
        this.other.unsafeSubscribe(otherSubscriber);
    }
}

