/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.message_format.message.BoldMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.EmojiMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.ItalicMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.LinkMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MentionMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import com.zoyi.channel.plugin.android.util.message_format.message.UnescapeMessage;
import java.util.ArrayList;
import java.util.List;

public class MessageParser {
    private final String ESCAPE_SEQUENCE = "```";
    private static MessageParser messageParser;
    private List<MessagePattern> patterns = new ArrayList<MessagePattern>();
    private int linkColor;

    public static MessageParser create() {
        if (messageParser == null) {
            messageParser = new MessageParser(ChannelIO.getAppContext());
        }
        return messageParser;
    }

    private MessageParser(Context context) {
        this.linkColor = ContextCompat.getColor((Context)context, (int)R.color.ch_cobalt);
        this.patterns.add(new EscapeMessage());
        this.patterns.add(new BoldMessage());
        this.patterns.add(new ItalicMessage());
        this.patterns.add(new MentionMessage());
        this.patterns.add(new EmojiMessage(AssetUtils.getEmojiDictionary(context)));
        this.patterns.add(new LinkMessage(this.linkColor));
        this.patterns.add(new UnescapeMessage());
    }

    public SpannableStringBuilder parse(@NonNull String message) {
        String[] tokens = message.split("```", -1);
        SpannableStringBuilder resultMessage = new SpannableStringBuilder();
        for (int index = 0; index < tokens.length; ++index) {
            if (TextUtils.isEmpty((CharSequence)tokens[index])) continue;
            SpannableStringBuilder parsedToken = this.parseString(tokens[index]);
            if (index % 2 == 0) {
                resultMessage.append((CharSequence)parsedToken);
                continue;
            }
            if (index == tokens.length - 1) {
                resultMessage.append((CharSequence)"```");
                resultMessage.append((CharSequence)parsedToken);
                continue;
            }
            resultMessage.append((CharSequence)tokens[index]);
        }
        return resultMessage;
    }

    public SpannableStringBuilder parseString(String message) {
        SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)message);
        for (MessagePattern messagePattern : this.patterns) {
            spannableString = messagePattern.parse(spannableString);
        }
        return spannableString;
    }
}

