/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;
import java.io.IOException;

public class RetrofitInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Channel channel;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        builder = builder.addHeader("Accept-Language", PrefSupervisor.getPluginLanguage(ChannelIO.getAppContext()));
        if (ChannelStore.getVeilId() != null) {
            builder.addHeader("X-Veil-Id", ChannelStore.getVeilId());
        }
        if (ChannelStore.getUserId() != null) {
            builder.addHeader("X-User-Id", ChannelStore.getUserId());
        }
        if ((channel = ChannelStore.getChannel()) != null && channel.getId() != null) {
            builder.addHeader("X-Channel-Id", channel.getId());
        }
        return chain.proceed(builder.build());
    }
}

