/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.ChannelLayout;

public class SettingsHeaderFragment
extends Fragment
implements View.OnClickListener {
    private ChannelLayout layoutChannelImage;
    private CHTextView textChannelName;
    private View layoutMenu;
    private ImageView homepage;
    private ImageView phone;
    private ImageView facebook;
    private ImageView instagram;
    private Context context;
    private Channel channel;
    private Plugin plugin;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ch_plugin_fragment_settings_header, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.context = this.getActivity();
        this.channel = ChannelStore.getChannel();
        this.plugin = ChannelStore.getPlugin();
        if (this.channel != null && this.plugin != null) {
            this.layoutChannelImage = (ChannelLayout)view.findViewById(R.id.layout_channel_image);
            this.textChannelName = (CHTextView)view.findViewById(R.id.tv_channel_name);
            this.layoutMenu = view.findViewById(R.id.layout_settings_menu);
            this.homepage = (ImageView)view.findViewById(R.id.iv_menu_homepage);
            this.phone = (ImageView)view.findViewById(R.id.iv_menu_phone);
            this.facebook = (ImageView)view.findViewById(R.id.iv_menu_facebook);
            this.instagram = (ImageView)view.findViewById(R.id.iv_menu_instagram);
            view.setBackgroundColor(Color.parseColor((String)this.plugin.getBorderColor()));
            this.setChannelImage(this.channel, this.plugin);
            this.textChannelName.setText(this.channel.getName());
            this.textChannelName.setTextColor(this.plugin.getTextColor());
            this.homepage.setOnClickListener((View.OnClickListener)this);
            this.phone.setOnClickListener((View.OnClickListener)this);
            this.facebook.setOnClickListener((View.OnClickListener)this);
            this.instagram.setOnClickListener((View.OnClickListener)this);
            this.decorateMenu();
        }
    }

    public void onClick(View v) {
        ChannelDialog channelDialog;
        int id2 = v.getId();
        if (id2 == R.id.iv_menu_homepage) {
            channelDialog = new ChannelDialog(this.context);
            ((ChannelDialog)((Object)((ChannelDialog)((Object)channelDialog.setDescription(this.channel.getHomepageUrl()).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, new View.OnClickListener(){

                public void onClick(View v) {
                    Executor.goWeb(SettingsHeaderFragment.this.context, SettingsHeaderFragment.this.channel.getHomepageUrl());
                }
            }))).show();
        }
        if (id2 == R.id.iv_menu_phone) {
            channelDialog = new ChannelDialog(this.context);
            ((ChannelDialog)((Object)((ChannelDialog)((Object)channelDialog.setDescription(this.channel.getPhoneNumber()).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, new View.OnClickListener(){

                public void onClick(View v) {
                    Executor.call(SettingsHeaderFragment.this.context, SettingsHeaderFragment.this.channel.getPhoneNumber());
                }
            }))).show();
        }
        if (id2 == R.id.iv_menu_facebook) {
            Executor.goWeb(this.context, null);
        }
        if (id2 == R.id.iv_menu_instagram) {
            Executor.goWeb(this.context, null);
        }
    }

    private void setChannelImage(Channel channel, Plugin plugin) {
        if (TextUtils.isEmpty((CharSequence)channel.getAvatarUrl())) {
            this.layoutChannelImage.set(channel, plugin);
        } else {
            this.layoutChannelImage.set(channel);
        }
    }

    private void decorateMenu() {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.textChannelName.getLayoutParams();
        String homepageUrl = this.channel.getHomepageUrl();
        String phoneNumber = this.channel.getPhoneNumber();
        if (TextUtils.isEmpty((CharSequence)homepageUrl) && TextUtils.isEmpty((CharSequence)phoneNumber)) {
            this.layoutMenu.setVisibility(8);
            params.bottomMargin = (int)Utils.dpToPx(this.context, 20.0f);
        } else {
            int textColorInt = this.plugin.getTextColor();
            this.homepage.setBackgroundResource(this.getBackgroundDrawableRes(textColorInt));
            this.homepage.setColorFilter(textColorInt);
            this.homepage.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty((CharSequence)homepageUrl), true));
            this.phone.setBackgroundResource(this.getBackgroundDrawableRes(textColorInt));
            this.phone.setColorFilter(textColorInt);
            this.phone.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty((CharSequence)phoneNumber), true));
            this.facebook.setBackgroundResource(this.getBackgroundDrawableRes(textColorInt));
            this.facebook.setColorFilter(textColorInt);
            this.facebook.setVisibility(8);
            this.instagram.setBackgroundResource(this.getBackgroundDrawableRes(textColorInt));
            this.instagram.setColorFilter(textColorInt);
            this.instagram.setVisibility(8);
            this.layoutMenu.setVisibility(0);
            this.setMenuMargin();
            params.bottomMargin = (int)Utils.dpToPx(this.context, 16.0f);
        }
        this.textChannelName.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void setMenuMargin() {
        LinearLayout.LayoutParams params;
        if (this.phone.getVisibility() == 0) {
            params = (LinearLayout.LayoutParams)this.homepage.getLayoutParams();
            params.rightMargin = (int)Utils.dpToPx(this.context, 14.0f);
            this.homepage.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.facebook.getVisibility() == 0) {
            params = (LinearLayout.LayoutParams)this.phone.getLayoutParams();
            params.rightMargin = (int)Utils.dpToPx(this.context, 14.0f);
            this.phone.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.instagram.getVisibility() == 0) {
            params = (LinearLayout.LayoutParams)this.facebook.getLayoutParams();
            params.rightMargin = (int)Utils.dpToPx(this.context, 14.0f);
            this.facebook.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @DrawableRes
    private int getBackgroundDrawableRes(int textColorInt) {
        return textColorInt == -1 ? R.drawable.ch_plugin_settings_menu_bright_bg : R.drawable.ch_plugin_settings_menu_dark_bg;
    }
}

