/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChatListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.LauncherBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.push.ChannelPushClient;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ChannelIO {
    private static final String MINT_DEBUG_KEY = "e72f17f4";
    private static final String MINT_PROD_KEY = "22464da6";
    private static boolean isDebugMode = false;
    private static boolean isEnabledTrackDefaultEvent = true;
    private static boolean isHideDefaultInAppPush = true;
    private static ChannelIO channelIO;
    private static ChannelApi channelApi;
    private static OnChatListener onChatListener;
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private AtomicInteger bootCounter = new AtomicInteger(0);
    private ActivityLifecycleManager activityLifecycleManager;

    private ChannelIO(Application application) {
        if (ChannelIO.isInitializedChannelIO()) {
            L.e("Channel plugin already initialized");
            return;
        }
        if (application == null) {
            L.e("Application cannot be null");
            return;
        }
        this.application = application;
        this.activityLifecycleManager = new ActivityLifecycleManager();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleManager);
        this.setUncaughtExceptionHandler();
        ChannelStore.create(application);
        SocketManager.create(application);
    }

    public static void initialize(@NonNull Application application) {
        channelIO = new ChannelIO(application);
    }

    public static void boot(ChannelPluginSettings pluginSettings) {
        ChannelIO.boot(pluginSettings, null, null);
    }

    public static void boot(ChannelPluginSettings pluginSettings, OnBootListener completion) {
        ChannelIO.boot(pluginSettings, null, completion);
    }

    public static void boot(ChannelPluginSettings pluginSettings, Profile profile) {
        ChannelIO.boot(pluginSettings, profile, null);
    }

    public static void boot(ChannelPluginSettings pluginSettings, Profile profile, OnBootListener completion) {
        if (ChannelIO.isInitializedChannelIO() && pluginSettings != null && pluginSettings.getPluginKey() != null) {
            channelIO.setChannelInfo(pluginSettings);
            channelIO.bootProcess(pluginSettings, profile, completion);
        } else {
            L.e("Check plugin information");
        }
    }

    public static void shutdown() {
        if (ChannelIO.isInitializedChannelIO()) {
            channelIO.shutdownProcess();
        }
    }

    public static boolean open(@NonNull Context context) {
        return ChannelIO.open(context, true);
    }

    public static boolean open(@NonNull Context context, boolean animated) {
        if (!ChannelIO.isInitializedChannelIO() || !ChannelIO.isDataStored()) {
            L.e("Please check in first");
            return false;
        }
        for (ChannelPluginListener l : ChannelStore.getChannelPluginListeners()) {
            if (l == null) continue;
            l.willShowMessenger();
        }
        if (ChannelIO.isEnabledTrackDefaultEvent() && ChannelStore.getPluginKey() != null) {
            ChannelIO.track(context, ChannelStore.getPluginKey(), "ChannelOpen", null);
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("animated", animated).startActivity();
        return true;
    }

    public static void close() {
        ChannelIO.close(true);
    }

    public static void close(boolean animated) {
        if (ChannelIO.isInitializedChannelIO()) {
            channelIO.finishAll(animated);
        }
    }

    public static void show() {
        RxBus.post(new LauncherBus(true));
    }

    public static void hide() {
        RxBus.post(new LauncherBus(false));
    }

    public static boolean openChat(@NonNull Context context) {
        return ChannelIO.openChat(context, null);
    }

    public static boolean openChat(@NonNull Context context, @Nullable String chatId) {
        if (!ChannelIO.isInitializedChannelIO() || !ChannelIO.isDataStored()) {
            L.e("Please Boot first");
            return false;
        }
        if (ChannelIO.isEnabledTrackDefaultEvent() && ChannelStore.getPluginKey() != null) {
            ChannelIO.track(context, ChannelStore.getPluginKey(), "ChannelOpen", null);
        }
        IntentUtils.setNextActivity(context, ChatActivity.class).putExtra("chatCount", 0).putExtra("firstChat", chatId == null).putExtra("chatId", chatId).startActivityForResult(21);
        return true;
    }

    public static void handlePushNotification(Context context) {
        ChannelPushClient.handlePushNotification(context);
    }

    public static void showPushNotification(Context context, Map<String, String> message) {
        ChannelPushManager.showPushNotification(context, message);
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(message);
    }

    private void setUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (Looper.getMainLooper().getThread() == thread) {
                    ChannelIO.this.uncaughtExceptionHandler.uncaughtException(thread, ex);
                } else if (ex instanceof RejectedExecutionException) {
                    SocketManager.reconnect();
                }
            }
        });
    }

    private void setChannelInfo(ChannelPluginSettings pluginSettings) {
        isDebugMode = pluginSettings.isDebugMode();
        isEnabledTrackDefaultEvent = pluginSettings.isEnabledTrackDefaultEvent();
        isHideDefaultInAppPush = pluginSettings.isHideDefaultInAppPush();
        ChannelStore.setPluginKey(pluginSettings.getPluginKey());
        PrefSupervisor.setPluginLanguage((Context)ChannelIO.channelIO.application, pluginSettings.getLocale());
        PrefSupervisor.setPluginSetting((Context)ChannelIO.channelIO.application, pluginSettings);
    }

    private void bootProcess(ChannelPluginSettings pluginSettings, Profile profile, OnBootListener listener) {
        if (ChannelIO.isDataStored()) {
            this.shutdownProcess();
        }
        channelIO.checkVersion(pluginSettings, profile, listener);
    }

    private void checkVersion(final ChannelPluginSettings pluginSettings, final Profile profile, final OnBootListener listener) {
        final int counter = this.bootCounter.incrementAndGet();
        ChannelIO.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "3.1.5").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PackageWrapper>(){

            @Override
            public void onError(Throwable error) {
                if (counter != ChannelIO.this.bootCounter.get()) {
                    return;
                }
                if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
                }
            }

            @Override
            public void onNext(PackageWrapper wrapper) {
                if (counter != ChannelIO.this.bootCounter.get()) {
                    return;
                }
                if (!wrapper.isNeedToUpgrade()) {
                    if (!CompareUtils.isSame(wrapper.getVersionString(), "3.1.5")) {
                        L.i("Newest version is: " + wrapper.getVersionString());
                    }
                    ChannelIO.this.bootChannelIO(pluginSettings, profile, listener, counter);
                } else if (listener != null) {
                    listener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, null);
                }
            }
        });
    }

    private void bootChannelIO(final ChannelPluginSettings pluginSettings, final Profile profile, final OnBootListener listener, final int counter) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        if (profile != null) {
            form.put("name", profile.getName());
            form.put("avatarUrl", profile.getAvatarUrl());
            form.put("mobileNumber", profile.getMobileNumber());
            for (Map.Entry<String, Object> entry : profile.getProperty().entrySet()) {
                form.put(entry.getKey(), entry.getValue());
            }
        }
        RequestBody body = RequestUtils.form(form).create();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)pluginSettings.getUserId())) {
            headers.put("X-User-Id", pluginSettings.getUserId());
        }
        ChannelIO.getApi().boot(headers, pluginSettings.getPluginKey(), body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(Throwable e) {
                if (counter != ChannelIO.this.bootCounter.get()) {
                    return;
                }
                L.e(e.getMessage());
                if (listener != null) {
                    ChannelPluginCompletionStatus status = ChannelPluginCompletionStatus.UNKNOWN_ERROR;
                    if (e instanceof RetrofitException) {
                        switch (((RetrofitException)e).getKind()) {
                            case HTTP: {
                                status = ChannelPluginCompletionStatus.NOT_INITIALIZED;
                                break;
                            }
                            case NETWORK: {
                                status = ChannelPluginCompletionStatus.NETWORK_TIMEOUT;
                                break;
                            }
                            default: {
                                status = ChannelPluginCompletionStatus.UNKNOWN_ERROR;
                            }
                        }
                    }
                    listener.onCompletion(status, null);
                }
            }

            @Override
            public void onNext(PluginWrapper pluginWrapper) {
                if (counter == ChannelIO.this.bootCounter.get() && !pluginWrapper.getChannel().isBlockedPlugin()) {
                    Channel channel = pluginWrapper.getChannel();
                    Plugin plugin = pluginWrapper.getPlugin();
                    if (pluginSettings.getUserId() != null) {
                        CheckInPrefSupervisor.setProfile((Context)ChannelIO.this.application, pluginSettings.getUserId(), profile);
                    }
                    CheckInPrefSupervisor.setVeil((Context)ChannelIO.this.application, pluginWrapper.getVeil());
                    ChannelStore.bootPlugin(pluginWrapper);
                    ChannelIO.this.initBugTracking(channel);
                    ChannelPushManager.sendTokenToChannelIO((Context)ChannelIO.this.application);
                    SocketManager.setChannelId(channel.getId());
                    SocketManager.connect();
                    if (!(pluginSettings.isHideDefaultLauncher() || plugin.isHideLauncher().booleanValue() || channel.isHideLauncher())) {
                        RxBus.post(new CommandBus(Command.SHOW_CHANNEL_VIEW, plugin));
                    }
                    if (pluginSettings.isEnabledTrackDefaultEvent()) {
                        ChannelIO.track((Context)ChannelIO.this.application, pluginSettings.getPluginKey(), "Boot", null);
                    }
                    if (listener != null) {
                        listener.onCompletion(ChannelPluginCompletionStatus.SUCCESS, pluginWrapper.getUser() != null ? pluginWrapper.getUser() : pluginWrapper.getVeil());
                    }
                }
            }
        });
    }

    private void shutdownProcess() {
        this.bootCounter.incrementAndGet();
        ChannelPushManager.deleteToken((Context)this.application);
        CheckInPrefSupervisor.clear((Context)this.application);
        ChannelStore.clear();
        RxBus.post(new CommandBus(Command.CHECKED_OUT));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChatManager.release();
        this.releaseBugTracking();
    }

    private void finishAll(boolean animated) {
        if (this.activityLifecycleManager != null) {
            this.activityLifecycleManager.finish(animated);
        }
    }

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    private void initBugTracking(Channel channel) {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession((Application)this.application, (String)MINT_PROD_KEY);
            Mint.addExtraData((String)"plugin_version", (String)"3.1.5");
            if (channel != null) {
                Mint.addExtraData((String)"channel_id", (String)channel.getId());
                Mint.addExtraData((String)"channel_name", (String)channel.getName());
            }
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession((Application)this.application);
            Mint.flush();
        }
    }

    public static void track(@NonNull Context context, @NonNull String pluginKey, @NonNull @Size(min=1L, max=30L) String eventName, @Nullable Map<String, Object> eventProperty) {
        if (TextUtils.isEmpty((CharSequence)eventName) || eventName.length() > 30) {
            return;
        }
        ChannelIO.track(new Event(context, pluginKey, eventName, eventProperty));
    }

    private static void track(@NonNull Event event) {
        ChannelIO.getApi().trackEvent(event).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
    }

    public static boolean isInitializedChannelIO() {
        return channelIO != null;
    }

    public static Context getAppContext() {
        if (channelIO != null) {
            return ChannelIO.channelIO.application.getApplicationContext();
        }
        return null;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isEnabledTrackDefaultEvent() {
        return isEnabledTrackDefaultEvent;
    }

    public static boolean isHideInAppPush() {
        return isHideDefaultInAppPush;
    }

    public static boolean isDataStored() {
        return ChannelStore.isDataStored();
    }

    public static void updateGuest() {
        ChannelIO.updateGuest(null);
    }

    public static void updateGuest(OnGuestUpdatedListener listener) {
        ChannelStore.fetchMe(listener);
    }

    public static void addChannelPluginListener(ChannelPluginListener listener) {
        ChannelStore.addChannelPluginListener(listener);
    }

    public static void removeChannelPluginListener(ChannelPluginListener listener) {
        ChannelStore.removeChannelPluginListener(listener);
    }

    public static List<ChannelPluginListener> getChannelPluginListeners() {
        return ChannelStore.getChannelPluginListeners();
    }

    static {
        onChatListener = null;
    }
}

