package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.util.L;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage.ESCAPE_POSTFIX;
import static com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage.ESCAPE_PREFIX;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class UnescapeMessage implements MessagePattern{

  private Pattern unescapePattern = Pattern.compile(ESCAPE_PREFIX + "[\\d]+" + ESCAPE_POSTFIX);

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {
    Matcher matcher = unescapePattern.matcher(span);

    while (matcher.find()) {
      try {
        int start = matcher.start();
        int end = matcher.end();

        String plainText = span.toString();

        String escape = asciiToString(plainText.substring(start + ESCAPE_PREFIX.length(), end - ESCAPE_POSTFIX.length()));
        span.delete(start, end);
        span.insert(start, escape);

        matcher = unescapePattern.matcher(span);
      } catch (IndexOutOfBoundsException indexException) {
        L.e(indexException.getMessage());
        return span;
      }
    }

    return span;
  }

  private String asciiToString(String ascii) {
    int asciiNum;
    String asciiChar;

    asciiNum = Integer.decode(ascii);

    asciiChar = Character.toString((char) asciiNum);
    return asciiChar;
  }
}
