package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatPresenter;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar.MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.MenuState;
import com.zoyi.channel.plugin.android.view.layout.WaterMarkLayout;

import static com.zoyi.channel.plugin.android.view.layout.MenuButton.ActionType;
import static com.zoyi.channel.plugin.android.view.layout.MenuButton.OnClickListener;

/**
 * Created by mika on 2016. 12. 5..
 */
public class UserChatListActivity extends BaseActivity implements OnClickListener, UserChatContract.View {

  private UserChatContract.Presenter presenter;

  private View emptyLayout;
  private View reconnectLayout;
  private RecyclerView chatList;
  private WaterMarkLayout waterMarkLayout;
  private LinearLayout rootView;
  private FloatingActionButton fab;
  private LinearLayoutManager layoutManager;

  private UserChatListAdapter adapter;

  private String tempChatId;
  private boolean showingChat = false;
  private boolean isRefreshUserChat = false;
  private boolean isPushClickedChat = false;

  private Channel channel;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_user_chat_list);

    if (getIntent() != null) {
      tempChatId = getIntent().getStringExtra(Const.EXTRA_CHAT_ID);
      isPushClickedChat = getIntent().getBooleanExtra(Const.EXTRA_PUSH_CLICK, false);
    }

    rootView = findViewById(R.id.root_view);
    emptyLayout = findViewById(R.id.layout_empty);
    reconnectLayout = findViewById(R.id.layout_reconnect);

    fab = (FloatingActionButton) findViewById(R.id.fab);
    fab.setOnClickListener(this);
    fab.hide(false);

    getBigBar().withActivity(this)
        .addMenu(ActionType.SETTINGS, MenuPosition.LEFT, MenuState.HIDDEN)
        .addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN)
        .addMenu(ActionType.EXIT, MenuPosition.RIGHT)
        .build();

    adapter = new UserChatListAdapter();

    presenter = new UserChatPresenter(this);
    presenter.setView(this);
    presenter.setAdapterView(adapter);
    presenter.setAdapterModel(adapter);

    channel = ChannelStore.getChannel();

    layoutManager = new LinearLayoutManager(this);
    chatList = (RecyclerView) findViewById(R.id.recycler_view);
    chatList.setLayoutManager(layoutManager);
    chatList.setAdapter(adapter);
    chatList.setItemAnimator(null);
    chatList.getRecycledViewPool().setMaxRecycledViews(0, 40);

    waterMarkLayout = (WaterMarkLayout) findViewById(R.id.chatlist_layout_water_mark);
    setWaterMarkLayout(channel);

    if (SocketManager.isError()) {
      setRefreshVisibility(true);
      setReconnectVisibility(true);
    }

    setStyle();
    presenter.getUserChats();
  }

  private void setWaterMarkLayout(final Channel channelInfo) {
    if (channelInfo != null && channelInfo.isTrial()) {
      waterMarkLayout.setVisibility(View.VISIBLE);

      waterMarkLayout.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          Executor.goWeb(getBaseContext(),
              String.format(
                  Const.UTM_URL,
                  PrefSupervisor.getPluginLanguage(UserChatListActivity.this),
                  "plugin_watermark",
                  channelInfo.getName(),
                  channelInfo.getId()));
        }
      });

      chatList.addOnScrollListener(new InfiniteScrollListener(
          layoutManager,
          InfiniteScrollListener.BOTTOM,
          chatList) {

        @Override
        public void scrolledInList() {
          waterMarkLayout.setVisibility(View.GONE);
        }

        @Override
        public void scrollAttachedToBottom() {
          waterMarkLayout.setVisibility(View.VISIBLE);
        }

        @Override
        public void refresh() {
          // not yet.
        }
      });

    } else {
      waterMarkLayout.setVisibility(View.GONE);
      chatList.setPadding(0, 0, 0, 0);
    }

    if (!animated) {
      overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
    }
  }

  @Override
  protected void onDestroy() {
    if (presenter != null) {
      presenter.release();
    }
    super.onDestroy();
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    super.onActivityResult(requestCode, resultCode, data);

    rootView.setVisibility(View.VISIBLE);

    switch (requestCode) {
      case Const.REQUEST_PLUGIIN_SETTINGS:
        if (resultCode == Const.RESULT_CHAT_OPTION_CHANGED) {
          refreshUserChat();
        }
        break;

      case Const.REQUEST_CHAT:
        showingChat = false;
        switch (resultCode) {
          case Const.RESULT_CHAT_OPEN_NEW_CHAT:
            startChat(null, presenter.getChatCount(null), false);
            break;

          case Const.RESULT_CHAT_OPTION_CHANGED:
            refreshUserChat();
            break;

          case Const.RESULT_CHAT_GO_TO_MAIN:
            finish();
            break;
        }
        break;
    }
  }

  @Override
  protected void onStart() {
    presenter.setRunningChatId(null);
    ChannelPushManager.sendTokenToChannelIO(ChannelIO.getAppContext());
    super.onStart();
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.fab) {
      startChat(null, presenter.getChatCount(null), adapter.getItemCount() == 0);
    }
  }

  @Override
  public void optionClicked(ActionType actionType) {
    switch (actionType) {
      case REFRESH:
        getBigBar().setMenuState(ActionType.REFRESH, MenuState.HIDDEN);
        presenter.refresh();
        break;

      case SETTINGS:
        IntentUtils.setNextActivity(this, SettingsActivity.class)
            .startActivityForResult(Const.REQUEST_PLUGIIN_SETTINGS);
        break;
    }
    super.optionClicked(actionType);
  }

  private void setStyle() {
    Plugin plugin = ChannelStore.getPlugin();

    if (channel == null || plugin == null) {
      finish();
    } else {
      setStatusBarColor(plugin.getBackgroundColor());
      getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());

      getBigBar().setTitle(channel.getName());

      fab.setColorNormal(plugin.getBackgroundColor());
      fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
      fab.setColorRipple(Color.WHITE);
      fab.setImageResource(
          plugin.getTextColor() == Color.BLACK
              ? R.drawable.ch_plugin_ic_add_black_24dp
              : R.drawable.ch_plugin_ic_add_white_24dp);

      fab.attachToRecyclerView(chatList);
    }
  }

  private void refreshUserChat() {
    isRefreshUserChat = true;

    presenter.setInit(true);
    presenter.getUserChats();
  }

  @Override
  public void userChatsFetched(UserChatsWrapper userChatsWrapper, boolean init) {
    getBigBar().setMenuState(ActionType.SETTINGS, MenuState.VISIBLE);

    fab.show();

    if (tempChatId != null) {
      startChat(tempChatId, presenter.getChatCount(tempChatId), isPushClickedChat);
      tempChatId = null;
    } else {
      if (adapter.getItemCount() <= 1 && !isRefreshUserChat && !showingChat && init) {
        if (adapter.getItemCount() == 0) {
          startChat(null, 0, true);
        } else {
          String chatId = adapter.getChatId(0);
          startChat(chatId, 0, true);
        }

      } else {
        rootView.setVisibility(View.VISIBLE);
      }
      isRefreshUserChat = false;
    }

    setViewVisibility();
  }

  @Override
  public void startChat(String chatId, int chatCount, boolean isFirstChat) {
    showingChat = true;

    IntentUtils.setNextActivity(this, ChatActivity.class)
        .putExtra(Const.EXTRA_CHAT_ID, chatId)
        .putExtra(Const.EXTRA_CHAT_COUNT, chatCount)
        .putExtra(Const.EXTRA_CHAT_FIRST, isFirstChat)
        .putExtra(Const.EXTRA_ANIMATED, animated)
        .startActivityForResult(Const.REQUEST_CHAT);
  }

  @Override
  public void setRefreshVisibility(boolean showRefresh) {
    getBigBar().setMenuState(ActionType.REFRESH, showRefresh ? MenuState.VISIBLE : MenuState.HIDDEN);
  }

  @Override
  public void setReconnectVisibility(boolean show) {
    reconnectLayout.setVisibility(UIUtils.getVisible(show, true));
  }

  @Override
  public void checkUserChat(boolean hasCheckedChat) {
    getBigBar().setMenuState(ActionType.DELETE, hasCheckedChat ? MenuState.VISIBLE : MenuState.DISABLED);
  }

  @Override
  public void deleteChat(final String chatId) {
    UIUtils.showAlertDialog(this, ResUtils.getString(this, "ch.chat.delete_description"), true, new AlertDialogListener() {
      @Override
      public void onPositive() {
        presenter.requestRemoveChat(chatId);
      }
    });
  }

  @Override
  public void completeRemoveChat() {
    hideProgress();

    setViewVisibility();
  }

  @Override
  public void receiveCommand(Command command, Object object) {
    presenter.receiveCommand(command, object);
  }

  @Override
  public void receiveData(ChannelModel channelModel, boolean upsert) {
    presenter.receiveData(channelModel, upsert);

    setViewVisibility();
  }

  private void setViewVisibility() {
    emptyLayout.setVisibility(UIUtils.getVisible(!hasUserChat(), true));
    chatList.setVisibility(UIUtils.getVisible(hasUserChat(), true));
  }

  private boolean hasUserChat() {
    return adapter.getItemCount() > 0;
  }

  @Override
  @AnimRes
  protected int getEnterAnimOfCreate() {
    return R.anim.ch_plugin_slide_in_bottom;
  }

  @Override
  @AnimRes
  protected int getExistAnimOfFinish() {
    return R.anim.ch_plugin_slide_out_bottom;
  }
}
