package com.zoyi.channel.plugin.android.activity.download;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.DownloadUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.DownloadProgressBar;
import com.zoyi.okhttp3.Call;

import java.io.File;

/**
 * Created by mika on 2017. 1. 11..
 */
public class DownloadActivity extends BaseActivity implements View.OnClickListener {
  private DownloadProgressBar progress;
  private View imageDone;
  private FrameLayout imageCancel;

  private String url, filename;
  private boolean image;
  private Call call;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_download);
    setStatusBarColor(Color.BLACK);

    progress = (DownloadProgressBar) findViewById(R.id.download_progress);
    imageDone = findViewById(R.id.image_done);
    imageCancel = (FrameLayout) findViewById(R.id.layout_cancel);

    imageCancel.setOnClickListener(this);

    if (getIntent() != null) {
      url = getIntent().getStringExtra(Const.EXTRA_URL);
      filename = getIntent().getStringExtra(Const.EXTRA_FILE_NAME);
      image = getIntent().getBooleanExtra(Const.EXTRA_IMAGE, false);

      if (!TextUtils.isEmpty(url) && !TextUtils.isEmpty(filename)) {
        startDownload();
      } else {
        finish(Const.DOWNLOAD_FAILED);
      }
    } else {
      finish(Const.DOWNLOAD_FAILED);
    }
  }

  @Override
  public void onBackPressed() { }

  @Override
  protected void onPause() {
    super.onPause();
    overridePendingTransition(0, 0);
  }

  private void finish(int resultCode) {
    setResult(resultCode);
    finish();
  }

  @Override
  protected void permissionAccepted(int requestCode) {
    if (requestCode == PERMISSION_WRITE_STORAGE) {
      startDownload();
    } else {
      finish(Const.DOWNLOAD_FAILED);
    }
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.layout_cancel) {
      try {
        if (call != null && !call.isCanceled()) {
          call.cancel();
        }
      } catch (Exception ignored) {
      }
    }
  }

  private void startDownload() {
    if (checkPermission(PERMISSION_WRITE_STORAGE)) {
      call = DownloadUtils.downloadFile(
          this,
          url,
          filename,
          image,
          new DownloadUtils.ProgressListener() {
            @Override
            public void update(int progress) {
              progressDownload(progress);
            }

            @Override
            public void error(Call call, String message) {
              L.e(message);

              if (call == null || !call.isCanceled()) {
                finish(Const.DOWNLOAD_FAILED);
              } else {
                finish(Const.DOWNLOAD_CANCEL);
              }
            }

            @Override
            public void done(String savePath) {
              finishDownload(savePath);
            }
          });

      if (call == null) {
        finish(Const.DOWNLOAD_FAILED);
      }
    }
  }

  private void progressDownload(int progress) {
    this.progress.setProgress(progress);
  }

  private void finishDownload(String savePath) {
    imageDone.setVisibility(View.VISIBLE);
    imageCancel.setVisibility(View.GONE);
    progress.setVisibility(View.GONE);

    if (!image) {
      File file = new File(savePath);
      if (file.exists()) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String ext = FilenameUtils.getExtension(savePath).toLowerCase();
        String type = mimeTypeMap.getMimeTypeFromExtension(ext);

        try {
          Intent intent = new Intent(Intent.ACTION_VIEW);

          intent.setDataAndType(ChannelFileProvider.getUriForFile(this, file), type);
          intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
          intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

          startActivity(intent);
        } catch (Exception ex) {
          L.e(ex.getMessage());
        }
      }
    }

    Animation animation = AnimationUtils.loadAnimation(this, R.anim.ch_plugin_dialog_in);
    animation.setAnimationListener(new SimpleAnimationListener() {
      @Override
      public void onAnimationEnd(Animation animation) {
        finish(Const.DOWNLOAD_COMPLETE);
      }
    });
    imageDone.startAnimation(animation);
  }

  @Override
  protected int getEnterAnimOfCreate() {
    return R.anim.ch_plugin_idle;
  }

  @Override
  protected int getExistAnimOfCreate() {
    return R.anim.ch_plugin_idle;
  }

  @Override
  protected int getEnterAnimOfFinish() {
    return R.anim.ch_plugin_idle;
  }

  @Override
  protected int getExistAnimOfFinish() {
    return R.anim.ch_plugin_idle;
  }
}
