package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 8..
 */
public class ChatMessageItem implements MessageItem {
  private Message message;
  private MessageType type;

  private int messageColor;
  private int messageBackgroundColor;

  public ChatMessageItem() {
  }

  public ChatMessageItem(Message message, int messageColor, int messageBackgroundColor) {
    this.message = message;
    this.messageColor = messageColor;
    this.messageBackgroundColor = messageBackgroundColor;

    if (this.message != null) {
      switch(this.message.getPersonType()){
        case Manager.CLASSNAME:
          this.type = getManagerMessageType();
          break;

        case User.CLASSNAME:
        case Veil.CLASSNAME:
          this.type = getGuestMessageType();
          break;

        case Bot.CLASSNAME:
          this.type = getBotMessageType();
          break;

        default :
          type = MessageType.UNKNOWN;
      }
    }
  }

  @Override
  public Long getFirst() {
    if (message != null) {
      return message.getCreatedAt();
    }
    return 0L;
  }

  @Override
  public String getSecond() {
    if (message != null) {
      return message.getId();
    }
    return "";
  }

  public Message getMessage() {
    return message;
  }

  public MessageType getType() {
    return type;
  }

  public boolean isConnected(MessageItem p2) {
    if (p2 == null || !(p2 instanceof ChatMessageItem)) {
      return false;
    }

    if (this.getType() != p2.getType()) {
      return false;
    }

    Message m1 = this.message;
    Message m2 = ((ChatMessageItem) p2).getMessage();

    if (this.getType() == MessageType.MANAGER_MESSAGE) {
      if (m1 == null || m2 == null) {
        return false;
      }
      if (CompareUtils.compare(m1.getPersonId(), m2.getPersonId()) != 0) {
        return false;
      }
    }

    String t1 = TimeUtils.get(TimeUtils.MINUTE_24, m1.getCreatedAt());
    String t2 = TimeUtils.get(TimeUtils.MINUTE_24, m2.getCreatedAt());
    return CompareUtils.compare(t1, t2) == 0;
  }

  public String getPersonType() {
    if (message != null) {
      return message.getPersonType();
    }
    return null;
  }

  public String getPersonId() {
    if (message != null) {
      return message.getPersonId();
    }
    return null;
  }

  public int getMessageBackgroundColor() {
    return messageBackgroundColor;
  }

  public int getMessageColor() {
    return messageColor;
  }

  private MessageType getGuestMessageType() {
    if (message.getWebPage() != null) {
      return MessageType.GUEST_WEB_MESSAGE;
    } else if (message.getFile() != null
        && message.getFile().isImage()
        && message.getFile().getPreviewThumb() != null) {
      return MessageType.GUEST_IMAGE_MESSAGE;
    } else if (message.getFile() != null) {
      return MessageType.GUEST_FILE_MESSAGE;
    }
    return MessageType.GUEST_TEXT_MESSAGE;
  }

  private MessageType getManagerMessageType() {
    if (message.getWebPage() != null) {
      return MessageType.MANAGER_WEB_MESSAGE;
    } else if (message.getFile() != null
        && message.getFile().isImage()
        && message.getFile().getPreviewThumb() != null) {
      return MessageType.MANAGER_IMAGE_MESSAGE;
    } else if (message.getFile() != null) {
      return MessageType.MANAGER_FILE_MESSAGE;
    }
    return MessageType.MANAGER_TEXT_MESSAGE;
  }

  private MessageType getBotMessageType() {
    if (message.getWebPage() != null) {
      return MessageType.BOT_WEB_MESSAGE;
    } else if (message.getFile() != null
        && message.getFile().isImage()
        && message.getFile().getPreviewThumb() != null) {
      return MessageType.BOT_IMAGE_MESSAGE;
    } else if (message.getFile() != null) {
      return MessageType.BOT_FILE_MESSAGE;
    }
    return MessageType.BOT_TEXT_MESSAGE;
  }
}
