/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.listener.OnLanguageItemClickListener;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class SelectableLanguageItem
extends RelativeLayout
implements View.OnClickListener {
    private Context context;
    private CHTextView languageText;
    private ImageView checkImage;
    private CHLocale channelLanguage;
    private OnLanguageItemClickListener onLanguageItemClickListener;

    public SelectableLanguageItem(Context context) {
        super(context);
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_item_selectable_lang, (ViewGroup)this);
        this.languageText = (CHTextView)view.findViewById(R.id.ch_text_selectable_lang);
        this.checkImage = (ImageView)view.findViewById(R.id.ch_img_selectable_lang_chcek);
        view.findViewById(R.id.ch_root_selectable_lang).setOnClickListener((View.OnClickListener)this);
    }

    public void setListener(OnLanguageItemClickListener onLanguageItemClickListener) {
        this.onLanguageItemClickListener = onLanguageItemClickListener;
    }

    @NonNull
    public CHLocale getLanguage() {
        return this.channelLanguage;
    }

    public void setLanguage(@NonNull CHLocale channelLanguage) {
        this.channelLanguage = channelLanguage;
        switch (this.channelLanguage) {
            case KOREA: {
                this.setLanguageText(ResUtils.getString(this.context, "ko"));
                break;
            }
            case JAPAN: {
                this.setLanguageText(ResUtils.getString(this.context, "ja"));
                break;
            }
            default: {
                this.setLanguageText(ResUtils.getString(this.context, "en"));
            }
        }
    }

    private void setLanguageText(String text) {
        this.languageText.setText(text);
    }

    private void setCheckVisibility(boolean isClicked) {
        this.checkImage.setVisibility(UIUtils.getVisible(isClicked, true));
    }

    private void setTextColor(boolean isClicked) {
        int textColor = isClicked ? ContextCompat.getColor((Context)this.context, (int)R.color.ch_dark) : ContextCompat.getColor((Context)this.context, (int)R.color.ch_light);
        this.languageText.setTextColor(textColor);
    }

    public void setSelectedLanguage(boolean isSelectedLanguage) {
        if (isSelectedLanguage) {
            this.setStyle(true);
        }
    }

    public void setStyle(boolean isSelectedItem) {
        this.setCheckVisibility(isSelectedItem);
        this.setTextColor(isSelectedItem);
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.ch_root_selectable_lang) {
            this.setStyle(true);
            if (this.onLanguageItemClickListener != null) {
                this.onLanguageItemClickListener.onItemClick(this.getLanguage());
            }
        }
    }
}

