package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.util.L;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class EmojiMessage implements MessagePattern {

  private Pattern emojiPattern = Pattern.compile("(:)([a-zA-Z0-9_+-]+?)\\1");

  private JSONObject emojiMap;

  public EmojiMessage(JSONObject emojiMap) {
    this.emojiMap = emojiMap;
  }

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {
    Matcher matcher = emojiPattern.matcher(span);

    while (matcher.find()) {
      try {
        int start = matcher.start();
        int end = matcher.end();

        String emojiKey = span.toString().substring(start + 1, end - 1);

        if (emojiMap != null) {
          try {
            String emojiValue = (String) emojiMap.get(emojiKey);
            span.delete(start, end);
            span.insert(start, emojiValue);

          } catch (JSONException e) {
            L.e(e.toString());
            return span;
          }
        }

        matcher = emojiPattern.matcher(span);
      } catch (IndexOutOfBoundsException indexException) {
        L.e(indexException.getMessage());
        return span;
      }
    }

    return span;
  }
}
