package com.zoyi.channel.plugin.android.activity.video;

import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageButton;

import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.IntentUtils;

public class VideoViewerActivity extends BaseActivity {

  private PlayerView videoPlayerView;
  private SimpleExoPlayer exoPlayer;
  private ImageButton downloadButton;

  private String url;
  private String fileName;

  private long lastPosition;
  private boolean playWhenReady;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.activity_video_loader);

    url = getIntent().getStringExtra(Const.EXTRA_URL);
    fileName = getIntent().getStringExtra(Const.EXTRA_FILE_NAME);

    if (url != null && fileName != null) {
      videoPlayerView = findViewById(R.id.view_video_player);
      downloadButton = findViewById(R.id.exo_download);
      downloadButton.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          IntentUtils.setNextActivity(VideoViewerActivity.this, DownloadActivity.class)
              .putExtra(Const.EXTRA_URL, url)
              .putExtra(Const.EXTRA_FILE_NAME, fileName)
              .putExtra(Const.EXTRA_IMAGE, false)
              .startActivity();
        }
      });

      BandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
      TrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory(bandwidthMeter);
      TrackSelector trackSelector = new DefaultTrackSelector(videoTrackSelectionFactory);

      exoPlayer = ExoPlayerFactory.newSimpleInstance(new DefaultRenderersFactory(this), trackSelector);
      videoPlayerView.setPlayer(exoPlayer);

      DataSource.Factory dataSourceFactory = new DefaultDataSourceFactory(this, Util.getUserAgent(this, "ChannelDesk"));

      MediaSource videoSource = new ExtractorMediaSource.Factory(dataSourceFactory).createMediaSource(Uri.parse(url));
      exoPlayer.prepare(videoSource);
    } else {
      finish();
    }
  }

  @Override
  protected void onStart() {
    super.onStart();

    exoPlayer.seekTo(lastPosition);
    exoPlayer.setPlayWhenReady(playWhenReady);
  }

  @Override
  protected void onStop() {
    super.onStop();

    lastPosition = exoPlayer.getCurrentPosition();
    playWhenReady = exoPlayer.getPlayWhenReady();

    exoPlayer.setPlayWhenReady(false);
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();

    if (exoPlayer != null) {
      exoPlayer.release();
      exoPlayer = null;
    }
  }
}
