package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.type.UserInfoType;

/**
 * Created by mika on 2017. 2. 7..
 */
public class UserInfoItem implements MessageItem {

  private UserInfoType userInfoType;
  private Long timestamp;
  private String error;

  public UserInfoItem(UserInfoType userInfoType, Long timestamp, String error) {
    this.userInfoType = userInfoType;
    this.timestamp = timestamp + 1;
    this.error = error;
  }

  @Override
  public Long getFirst() {
    return timestamp;
  }

  @Override
  public String getSecond() {
    return "UserInfoItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.USER_INFO;
  }

  public UserInfoType getUserInfoType() {
    return userInfoType;
  }

  public Long getTimestamp() {
    return timestamp;
  }

  public boolean hasError() {
    return error != null;
  }

  public String getError() {
    return error;
  }

  public void setError(String error) {
    this.error = error;
  }
}
