/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.OperatorDebounceWithTime;
import com.zoyi.rx.observers.SerializedSubscriber;
import com.zoyi.rx.subscriptions.SerialSubscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorDebounceWithSelector<T, U>
implements Observable.Operator<T, T> {
    final Func1<? super T, ? extends Observable<U>> selector;

    public OperatorDebounceWithSelector(Func1<? super T, ? extends Observable<U>> selector) {
        this.selector = selector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final SerialSubscription serial = new SerialSubscription();
        child.add(serial);
        return new Subscriber<T>(child){
            final OperatorDebounceWithTime.DebounceState<T> state;
            final Subscriber<?> self;
            {
                super(subscriber);
                this.state = new OperatorDebounceWithTime.DebounceState();
                this.self = this;
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T t) {
                Observable debouncer;
                try {
                    debouncer = OperatorDebounceWithSelector.this.selector.call(t);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this);
                    return;
                }
                final int index = this.state.next(t);
                Subscriber debounceSubscriber = new Subscriber<U>(){

                    @Override
                    public void onNext(U t) {
                        this.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e) {
                        self.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        state.emit(index, s, self);
                        this.unsubscribe();
                    }
                };
                serial.set(debounceSubscriber);
                debouncer.unsafeSubscribe(debounceSubscriber);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
                this.state.clear();
            }

            @Override
            public void onCompleted() {
                this.state.emitAndComplete(s, this);
            }
        };
    }
}

