/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

class UserChatHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private Context context;
    private AvatarLayout avatar;
    private CHTextView textName;
    private CHTextView textMessage;
    private CHTextView textTime;
    private CHTextView textBadge;
    private UserChat userChat;
    private OnUserChatClickListener listener;

    public static UserChatHolder newInstance(ViewGroup parent, OnUserChatClickListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View itemView = inflater.inflate(R.layout.ch_plugin_item_user_chat, parent, false);
        return new UserChatHolder(itemView, listener);
    }

    UserChatHolder(View itemView, OnUserChatClickListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.listener = listener;
        this.avatar = (AvatarLayout)itemView.findViewById(R.id.avatar_single);
        this.avatar.setTextSize(16);
        this.textName = (CHTextView)itemView.findViewById(R.id.text_name);
        this.textMessage = (CHTextView)itemView.findViewById(R.id.text_message);
        this.textTime = (CHTextView)itemView.findViewById(R.id.text_time);
        this.textBadge = (CHTextView)itemView.findViewById(R.id.text_badge);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    void setUserChatItem(UserChatItem item) {
        this.userChat = item.getUserChat();
        Message message = item.getMessage();
        Session session = item.getSession();
        ProfileEntity profileEntity = item.getProfile();
        this.avatar.set(profileEntity);
        this.textName.setText(profileEntity == null ? ResUtils.getString(this.context, "ch.unknown") : profileEntity.getName());
        this.setTextMessage(message);
        this.setTextTime(message);
        if (session != null && session.getAlert() != null && session.getAlert() > 0) {
            this.textBadge.setVisibility(0);
            this.textBadge.setText(Utils.getCount(session.getAlert(), true));
        } else {
            this.textBadge.setVisibility(4);
        }
    }

    private void setTextMessage(Message message) {
        if (this.userChat.isStateResolved()) {
            this.textMessage.setTextByKey("ch.review.require.preview");
            this.textMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_dark));
        } else if (this.userChat.isStateClosed()) {
            this.textMessage.setTextByKey("ch.review.complete.preview");
            this.textMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_light));
        } else {
            this.textMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_dark));
            if (message != null) {
                if (message.getMessage() != null) {
                    this.textMessage.setText(message.getFormattedStringMessage());
                } else if (message.getFile() != null) {
                    if (message.getFile().isImage()) {
                        this.textMessage.setTextByKey("ch.notification.upload_image.description");
                    } else {
                        this.textMessage.setTextByKey("ch.notification.upload_file.description");
                    }
                } else {
                    this.textMessage.setText("");
                }
            } else {
                this.textMessage.setText("");
            }
        }
    }

    private void setTextTime(Message message) {
        if (this.userChat != null) {
            if (this.userChat.isStateResolved()) {
                this.textTime.setText(TimeUtils.get(this.userChat.getResolvedAt()));
            } else if (message != null) {
                this.textTime.setText(TimeUtils.get(message.getCreatedAt()));
            } else {
                this.textTime.setText(TimeUtils.get(this.userChat.getUpdatedAt()));
            }
        } else {
            this.textTime.setText(" ");
        }
    }

    public String getChatId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    public void onClick(View view) {
        this.listener.onUserChatClick(this.getChatId());
    }

    public boolean onLongClick(View v) {
        this.listener.onUserChatLongClick(this.getChatId());
        return true;
    }
}

