/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChangeInputStateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileEventListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.MobileNumberProfileMessageView;
import com.zoyi.channel.plugin.android.activity.chat.view.ProfileMessageView;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.interfaces.GuestEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileBotMessageHolder
extends RecyclerView.ViewHolder
implements OnProfileEventListener,
OnChangeInputStateListener {
    private Context context;
    private OnProfileUpdateListener onProfileUpdateListener;
    private LinearLayout profileItems;
    private CHTextView terms;
    private boolean init = false;
    private boolean hasFocus = false;
    private Map<String, ProfileMessageView> profileInputViewMap;
    private ProfileBotMessageItem item;

    public static ProfileBotMessageHolder newInstance(ViewGroup parent, OnProfileUpdateListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new ProfileBotMessageHolder(inflater.inflate(R.layout.ch_plugin_item_message_profile, parent, false), listener);
    }

    public ProfileBotMessageHolder(View itemView, OnProfileUpdateListener onProfileUpdateListener) {
        super(itemView);
        this.context = itemView.getContext();
        this.onProfileUpdateListener = onProfileUpdateListener;
        this.profileItems = (LinearLayout)itemView.findViewById(R.id.ch_layout_message_profile_items);
        this.terms = (CHTextView)itemView.findViewById(R.id.ch_view_message_profile_terms);
    }

    private void initView(Message message) {
        this.init = true;
        this.profileInputViewMap = new HashMap<String, ProfileMessageView>();
        if (message != null && message.getProfileBot() != null) {
            List<ProfileBot> profileBots = message.getProfileBot();
            for (ProfileBot profileBot : profileBots) {
                ProfileMessageView profileMessageView = "mobileNumber".equals(profileBot.getKey()) ? new MobileNumberProfileMessageView(this.context, this, this) : new ProfileMessageView(this.context, this, this);
                profileMessageView.setKey(profileBot.getKey());
                profileMessageView.setType(profileBot.getType());
                this.profileInputViewMap.put(profileBot.getKey(), profileMessageView);
                this.profileItems.addView((View)profileMessageView);
            }
        }
        this.setTerms(PrefSupervisor.getPluginLanguage(this.context));
    }

    public void bind(ProfileBotMessageItem item, boolean hasMessageEditTextFocus) {
        this.item = item;
        Message message = item.getMessage();
        if (!this.init) {
            this.initView(message);
        }
        if (message != null && message.getProfileBot() != null) {
            List<ProfileBot> profileBots = message.getProfileBot();
            boolean inputActivated = false;
            int activatedIndex = profileBots.size();
            for (int index = 0; index < profileBots.size(); ++index) {
                ProfileBot profileBot = profileBots.get(index);
                String profileKey = profileBot.getKey();
                if (!this.profileInputViewMap.containsKey(profileKey)) continue;
                ProfileMessageView profileMessageView = this.profileInputViewMap.get(profileKey);
                if (inputActivated) {
                    profileMessageView.setVisibility(8);
                    continue;
                }
                Object inputState = null;
                String error = null;
                boolean isLoading = false;
                if (CompareUtils.isSame(item.getInputKey(), profileKey)) {
                    error = item.getInputError();
                    inputState = item.getInputState();
                    isLoading = item.isInputLoading();
                }
                if (profileBot.getValue() == null || TextUtils.isEmpty((CharSequence)profileBot.getValue().toString())) {
                    GuestEntity guest;
                    inputActivated = true;
                    activatedIndex = index;
                    if (!CompareUtils.isSame(item.getInputKey(), profileKey) && (guest = ChannelStore.getGuest()) != null && guest.getProfileValue(profileKey) != null && !item.isLastProfileTyping()) {
                        inputState = "mobileNumber".equals(profileKey) ? new MobileNumber((String)guest.getProfileValue(profileKey)) : guest.getProfileValue(profileKey);
                    }
                }
                profileMessageView.setVisibility(0);
                profileMessageView.setState(profileBot.getNameI18n().get(PrefSupervisor.getPluginLanguage(this.context)), error, index + 1, profileBots.size(), profileBot.getValue(), inputState, isLoading, this.hasFocus || !hasMessageEditTextFocus && item.isLastProfileTyping(), index == profileBots.size() - 1);
            }
            if (activatedIndex > 0) {
                this.terms.setVisibility(8);
            }
            if (activatedIndex == profileBots.size() && this.onProfileUpdateListener != null) {
                this.onProfileUpdateListener.onCompleteWriteProfile();
            }
        }
    }

    private void setTerms(String lang) {
        this.terms.setText((CharSequence)Utils.getHtmlFormattedText(ResUtils.getString(this.context, "ch.agreement")));
        final String url = String.format("https://channel.io/%s/terms_user", lang);
        this.terms.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntentUtils.setUrl(ProfileBotMessageHolder.this.context, url).startActivity();
            }
        });
    }

    @Override
    public void onCountryCodeClick(String key, MobileNumber mobileNumber) {
        this.onProfileUpdateListener.getCountries(this.item, key, mobileNumber);
    }

    @Override
    public void onSendButtonClick(String key, Object value, Object inputState) {
        this.hasFocus = true;
        this.item.setInputState(inputState);
        this.onProfileUpdateListener.onProfileUpdate(this.item, key, value);
    }

    @Override
    public void onChangeFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
        this.onProfileUpdateListener.onChangeProfileFocus(hasFocus);
    }

    @Override
    public void onUpdateInputState(String key, Object inputState, boolean isTyping) {
        this.item.setLastProfileTypingState(isTyping);
        this.item.setInputState(key, inputState, false, null);
    }
}

