/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.handler.TextLinkClickListener;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.LinkedTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class ChatMessageHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
TextLinkClickListener {
    Context context;
    View root;
    View profileLayout;
    View headView;
    View contextView;
    View messageView;
    CHTextView textTime;
    LinkedTextView text;
    LinearLayout contentLayout;
    View webPageLayout;
    View fileLayout;
    View uploadLayout;
    MaskableFrameLayout imageLayout;
    ImageView imageContent;
    ImageView imagePlaceholder;
    ImageView imageUploading;
    CHTextView textFileName;
    CHTextView textFileInfo;
    ImageView imageIcon;
    CHTextView textWebTitle;
    CHTextView textWebDescription;
    View progressUpload;
    View imageUploadFailed;
    SendingMessageItem sendingMessageItem;
    Message message;
    OnMessageClickListener listener;

    public ChatMessageHolder(View itemView, OnMessageClickListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.listener = listener;
        this.root = itemView.findViewById(R.id.layout_message_root);
        this.profileLayout = itemView.findViewById(R.id.message_profile_layout);
        this.textTime = (CHTextView)itemView.findViewById(R.id.message_time);
        this.headView = itemView.findViewById(R.id.message_head);
        this.contextView = itemView.findViewById(R.id.message_context);
        this.messageView = itemView.findViewById(R.id.message_text_view);
        this.text = (LinkedTextView)itemView.findViewById(R.id.message_text);
        this.contentLayout = (LinearLayout)itemView.findViewById(R.id.layout_content);
        this.imageLayout = (MaskableFrameLayout)itemView.findViewById(R.id.content_image);
        this.webPageLayout = itemView.findViewById(R.id.content_webpage);
        this.fileLayout = itemView.findViewById(R.id.content_file);
        this.uploadLayout = itemView.findViewById(R.id.content_loading);
        this.imageContent = (ImageView)itemView.findViewById(R.id.image_chat);
        this.imagePlaceholder = (ImageView)itemView.findViewById(R.id.image_placeholder);
        this.textFileName = (CHTextView)itemView.findViewById(R.id.text_file_name);
        this.textFileInfo = (CHTextView)itemView.findViewById(R.id.text_file_info);
        this.imageIcon = (ImageView)itemView.findViewById(R.id.icon_file);
        this.textWebTitle = (CHTextView)itemView.findViewById(R.id.text_web_title);
        this.textWebDescription = (CHTextView)itemView.findViewById(R.id.text_web_description);
        this.imageUploading = (ImageView)itemView.findViewById(R.id.image_loading);
        this.progressUpload = itemView.findViewById(R.id.progress_upload);
        this.imageUploadFailed = itemView.findViewById(R.id.image_upload_failed);
        this.contentLayout.setVisibility(8);
        this.imageContent.setOnClickListener((View.OnClickListener)this);
        this.webPageLayout.setOnClickListener((View.OnClickListener)this);
        this.fileLayout.setOnClickListener((View.OnClickListener)this);
        this.text.setOnTextLinkClickListener(this);
    }

    private void setImage(PreviewThumb previewThumb, boolean webPage, String message) {
    }

    protected void setLayout(boolean isContext, Long time) {
        this.profileLayout.setVisibility(UIUtils.getVisible(!isContext, true));
        this.headView.setVisibility(UIUtils.getVisible(!isContext, true));
        this.contextView.setVisibility(UIUtils.getVisible(isContext, true));
        this.textTime.setVisibility(UIUtils.getVisible(time != null, true));
    }

    public void set(Message message, boolean isContext) {
        this.sendingMessageItem = null;
        this.message = message;
        if (message == null) {
            return;
        }
        this.setLayout(isContext, message.getCreatedAt());
        this.textTime.setText(TimeUtils.getTime(message.getCreatedAt()));
        if (message.getMessage() != null) {
            this.messageView.setVisibility(0);
            this.setText(message.getMessage());
        } else {
            this.messageView.setVisibility(8);
        }
        if (!message.hasContent()) {
            this.contentLayout.setVisibility(8);
        } else {
            this.contentLayout.setVisibility(0);
            for (int i = 0; i < this.contentLayout.getChildCount(); ++i) {
                this.contentLayout.getChildAt(i).setVisibility(8);
            }
            if (message.getFile() != null) {
                File file = message.getFile();
                if (file != null) {
                    if (file.isImage() && file.getPreviewThumb() != null) {
                        this.setImage(file.getPreviewThumb(), false, message.getMessage());
                    } else {
                        String fileSize = Utils.getProperBytes(file.getSize());
                        String fileType = "";
                        String extension = file.getExtension();
                        if (!"default".equals(extension) && !TextUtils.isEmpty((CharSequence)extension)) {
                            fileType = String.format(" \u00b7 %s", extension.substring(0, 1).toUpperCase() + extension.substring(1));
                        }
                        this.textFileName.setText(file.getFilename());
                        this.textFileInfo.setText(String.format("%s%s", fileSize, fileType));
                        this.imageIcon.setImageResource(ResUtils.getFileIconResourceId(file));
                        this.fileLayout.setVisibility(0);
                    }
                }
            } else if (message.getWebPage() != null) {
                WebPage webPage = message.getWebPage();
                this.setText(message.getMessage());
                if (webPage != null) {
                    this.webPageLayout.setVisibility(0);
                    if (webPage.getPreviewThumb() != null) {
                        this.setImage(webPage.getPreviewThumb(), true, message.getMessage());
                    }
                    if (!TextUtils.isEmpty((CharSequence)webPage.getTitle())) {
                        this.textWebTitle.setText(webPage.getTitle());
                    } else {
                        this.textWebTitle.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
                    }
                    if (!TextUtils.isEmpty((CharSequence)webPage.getDescription())) {
                        this.textWebDescription.setText(webPage.getTitle());
                    } else {
                        this.textWebDescription.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
                    }
                }
            }
        }
    }

    protected void setText(String text) {
        this.text.setLinkedText(text == null ? "" : text);
    }

    public void onClick(View v) {
        if (this.listener != null && this.message != null) {
            this.listener.messageClicked(this.message);
        }
    }

    @Override
    public void onTextLinkClick(View textView, String clickedString) {
        if (this.listener != null) {
            this.listener.urlClicked(clickedString);
        }
    }
}

