/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class ChatMessageItem
implements MessageItem {
    private Message message;
    private MessageType type;
    private int messageColor;
    private int messageBackgroundColor;

    public ChatMessageItem() {
    }

    public ChatMessageItem(Message message, int messageColor, int messageBackgroundColor) {
        this.message = message;
        this.messageColor = messageColor;
        this.messageBackgroundColor = messageBackgroundColor;
        if (this.message != null) {
            switch (this.message.getPersonType()) {
                case "Manager": {
                    this.type = this.getManagerMessageType();
                    break;
                }
                case "User": 
                case "Veil": {
                    this.type = this.getGuestMessageType();
                    break;
                }
                case "Bot": {
                    this.type = this.getBotMessageType();
                    break;
                }
                default: {
                    this.type = MessageType.UNKNOWN;
                }
            }
        }
    }

    @Override
    public Long getFirst() {
        if (this.message != null) {
            return this.message.getCreatedAt();
        }
        return 0L;
    }

    @Override
    public String getSecond() {
        if (this.message != null) {
            return this.message.getId();
        }
        return "";
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    public boolean isConnected(MessageItem p2) {
        String t2;
        String t1;
        if (p2 == null || !(p2 instanceof ChatMessageItem)) {
            return false;
        }
        if (this.getType() != p2.getType()) {
            return false;
        }
        Message m1 = this.message;
        Message m2 = ((ChatMessageItem)p2).getMessage();
        if (this.getType() == MessageType.MANAGER_MESSAGE) {
            if (m1 == null || m2 == null) {
                return false;
            }
            if (CompareUtils.compare(m1.getPersonId(), m2.getPersonId()) != 0) {
                return false;
            }
        }
        return CompareUtils.compare(t1 = TimeUtils.get(TimeUtils.MINUTE_24, m1.getCreatedAt()), t2 = TimeUtils.get(TimeUtils.MINUTE_24, m2.getCreatedAt())) == 0;
    }

    public String getPersonType() {
        if (this.message != null) {
            return this.message.getPersonType();
        }
        return null;
    }

    public String getPersonId() {
        if (this.message != null) {
            return this.message.getPersonId();
        }
        return null;
    }

    public int getMessageBackgroundColor() {
        return this.messageBackgroundColor;
    }

    public int getMessageColor() {
        return this.messageColor;
    }

    private MessageType getGuestMessageType() {
        if (this.message.getWebPage() != null) {
            return MessageType.GUEST_WEB_MESSAGE;
        }
        if (this.message.getFile() != null && this.message.getFile().isImage() && this.message.getFile().getPreviewThumb() != null) {
            return MessageType.GUEST_IMAGE_MESSAGE;
        }
        if (this.message.getFile() != null) {
            return MessageType.GUEST_FILE_MESSAGE;
        }
        return MessageType.GUEST_TEXT_MESSAGE;
    }

    private MessageType getManagerMessageType() {
        if (this.message.getWebPage() != null) {
            return MessageType.MANAGER_WEB_MESSAGE;
        }
        if (this.message.getFile() != null && this.message.getFile().isImage() && this.message.getFile().getPreviewThumb() != null) {
            return MessageType.MANAGER_IMAGE_MESSAGE;
        }
        if (this.message.getFile() != null) {
            return MessageType.MANAGER_FILE_MESSAGE;
        }
        return MessageType.MANAGER_TEXT_MESSAGE;
    }

    private MessageType getBotMessageType() {
        if (this.message.getWebPage() != null) {
            return MessageType.BOT_WEB_MESSAGE;
        }
        if (this.message.getFile() != null && this.message.getFile().isImage() && this.message.getFile().getPreviewThumb() != null) {
            return MessageType.BOT_IMAGE_MESSAGE;
        }
        if (this.message.getFile() != null) {
            return MessageType.BOT_FILE_MESSAGE;
        }
        return MessageType.BOT_TEXT_MESSAGE;
    }
}

