package com.zoyi.channel.plugin.android.model.source.userchat;

import com.zoyi.channel.plugin.android.activity.base.SortedItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChatItem implements SortedItem {
  private UserChatListDataDictionary dictionary;
  private UserChat userChat;
  private Session session;
  private Message message;

  public UserChatItem(UserChat userChat, UserChatListDataDictionary dictionary) {
    this.userChat = userChat;
    this.dictionary = dictionary;
    this.session = dictionary.get(Session.class, userChat.getSessionId());
    this.message = dictionary.get(Message.class, userChat.getLastMessageId());
  }

  public void setUserChat(UserChat userChat) {
    this.userChat = userChat;
    this.session = dictionary.get(Session.class, userChat.getSessionId());
    this.message = dictionary.get(Message.class, userChat.getLastMessageId());
  }

  public String getId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return "";
  }

  public ProfileEntity getProfile() {
    return dictionary.getProfile(userChat.getHostType(), userChat.getHostId());
  }

  public UserChat getUserChat() {
    return userChat;
  }

  public String getSessionId() {
    if (userChat != null) {
      return userChat.getSessionId();
    }
    return "";
  }

  public Session getSession() {
    return session;
  }

  public Message getMessage() {
    return message;
  }

  @Override
  public Long getFirst() {
    if (message != null) {
      return message.getCreatedAt();
    }
    return 0L;
  }

  @Override
  public String getSecond() {
    if (userChat != null) {
      return userChat.getId();
    }
    return "";
  }

  public void setSession(Session session) {
    this.session = session;
  }
}
