package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.ChannelLayout;

public class SettingsHeaderFragment extends Fragment implements View.OnClickListener {

  private ChannelLayout layoutChannelImage;
  private CHTextView textChannelName;
  private View layoutMenu;
  private ImageView homepage, phone, facebook, instagram;

  private Context context;
  private Channel channel;
  private Plugin plugin;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_settings_header, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    context = getActivity();
    channel = ChannelStore.getChannel();
    plugin = ChannelStore.getPlugin();

    if (channel != null && plugin != null) {
      layoutChannelImage = (ChannelLayout) view.findViewById(R.id.layout_channel_image);
      textChannelName = view.findViewById(R.id.tv_channel_name);
      layoutMenu = view.findViewById(R.id.layout_settings_menu);
      homepage = (ImageView) view.findViewById(R.id.iv_menu_homepage);
      phone = (ImageView) view.findViewById(R.id.iv_menu_phone);
      facebook = (ImageView) view.findViewById(R.id.iv_menu_facebook);
      instagram = (ImageView) view.findViewById(R.id.iv_menu_instagram);

      view.setBackgroundColor(Color.parseColor(plugin.getBorderColor()));
      setChannelImage(channel, plugin);

      textChannelName.setText(channel.getName());
      textChannelName.setTextColor(plugin.getTextColor());

      homepage.setOnClickListener(this);
      phone.setOnClickListener(this);
      facebook.setOnClickListener(this);
      instagram.setOnClickListener(this);

      decorateMenu();
    }
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.iv_menu_homepage) {
      ChannelDialog channelDialog = new ChannelDialog(context);
      channelDialog
          .setDescription(channel.getHomepageUrl())
          .addButton(ButtonType.CANCEL)
          .addButton(ButtonType.OK, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
              Executor.goWeb(context, channel.getHomepageUrl());
            }
          }).show();
    }
    if (id == R.id.iv_menu_phone) {
      ChannelDialog channelDialog = new ChannelDialog(context);
      channelDialog
          .setDescription(channel.getPhoneNumber())
          .addButton(ButtonType.CANCEL)
          .addButton(ButtonType.OK, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
              Executor.call(context, channel.getPhoneNumber());
            }
          }).show();
    }
    if (id == R.id.iv_menu_facebook) {
      Executor.goWeb(context, null);
    }
    if (id == R.id.iv_menu_instagram) {
      Executor.goWeb(context, null);
    }
  }

  private void setChannelImage(Channel channel, Plugin plugin) {
    if (TextUtils.isEmpty(channel.getAvatarUrl())) {
      layoutChannelImage.set(channel, plugin);
    } else {
      layoutChannelImage.set(channel);
    }
  }

  private void decorateMenu() {
    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) textChannelName.getLayoutParams();
    String homepageUrl = channel.getHomepageUrl();
    String phoneNumber = channel.getPhoneNumber();

    if (TextUtils.isEmpty(homepageUrl) && TextUtils.isEmpty(phoneNumber)) {
      layoutMenu.setVisibility(View.GONE);

      params.bottomMargin = (int) Utils.dpToPx(context, 20);
    } else {
      int textColorInt = plugin.getTextColor();

      homepage.setBackgroundResource(getBackgroundDrawableRes(textColorInt));
      homepage.setColorFilter(textColorInt);
      homepage.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty(homepageUrl), true));

      phone.setBackgroundResource(getBackgroundDrawableRes(textColorInt));
      phone.setColorFilter(textColorInt);
      phone.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty(phoneNumber), true));

      facebook.setBackgroundResource(getBackgroundDrawableRes(textColorInt));
      facebook.setColorFilter(textColorInt);
      facebook.setVisibility(View.GONE);

      instagram.setBackgroundResource(getBackgroundDrawableRes(textColorInt));
      instagram.setColorFilter(textColorInt);
      instagram.setVisibility(View.GONE);

      layoutMenu.setVisibility(View.VISIBLE);
      setMenuMargin();

      params.bottomMargin = (int) Utils.dpToPx(context, 16);
    }
    textChannelName.setLayoutParams(params);
  }

  private void setMenuMargin() {
    LinearLayout.LayoutParams params;
    if (phone.getVisibility() == View.VISIBLE) {
      params = (LinearLayout.LayoutParams) homepage.getLayoutParams();
      params.rightMargin = (int) Utils.dpToPx(context, 14);
      homepage.setLayoutParams(params);
    }
    if (facebook.getVisibility() == View.VISIBLE) {
      params = (LinearLayout.LayoutParams) phone.getLayoutParams();
      params.rightMargin = (int) Utils.dpToPx(context, 14);
      phone.setLayoutParams(params);
    }
    if (instagram.getVisibility() == View.VISIBLE) {
      params = (LinearLayout.LayoutParams) facebook.getLayoutParams();
      params.rightMargin = (int) Utils.dpToPx(context, 14);
      facebook.setLayoutParams(params);
    }
  }

  @DrawableRes
  private int getBackgroundDrawableRes(int textColorInt) {
    return textColorInt == Color.WHITE ?
        R.drawable.ch_plugin_settings_menu_bright_bg :
        R.drawable.ch_plugin_settings_menu_dark_bg;
  }
}
