package com.zoyi.channel.plugin.android.activity.chat;

import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChatListener;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.LinkableMessageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.presenter.chat.ChatContract;
import com.zoyi.channel.plugin.android.presenter.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.BigBar.MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.ChatRecyclerView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.MenuState;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.channel.plugin.android.view.layout.WaterMarkLayout;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

import java.util.List;

/**
 * Created by mika on 2016. 12. 7..
 */
public class ChatActivity
    extends BaseActivity
    implements
    ChatContract.View,
    EditTextChangedListener,
    View.OnClickListener,
    TopNavFragment.OnChatTopNavListener {

  private static final int DELAY_EXPAND_COLLAPSE = 512;

  private TopNavFragment topNavFragment;
  private ChatRecyclerView chatList;
  private WatchedEditText editChat;
  private ImageButton imageSend;
  private View layoutInput;
  private PreviewFragment previewFragment;
  private ChatCompltedFragment compltedFragment;
  private WaterMarkLayout waterMarkLayout;
  private CHTextView disabledInputText;

  private LinearLayoutManager layoutManager;
  private TypingManager typingManager;

  private ChatContract.Presenter presenter;

  private ChatAdapter adapter;
  private int currentPosition;

  private Subscription subscription;

  private Channel channel;

  private int enterAnimInCreate;
  private int existAnimInFinish;
  boolean isFirstChat;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_chat);

    String chatId = null;
    int chatCount = 0;
    isFirstChat = false;

    if (getIntent() != null) {
      chatId = getIntent().getStringExtra(Const.EXTRA_CHAT_ID);
      chatCount = getIntent().getIntExtra(Const.EXTRA_CHAT_COUNT, 0);
      isFirstChat = getIntent().getBooleanExtra(Const.EXTRA_CHAT_FIRST, false);
    }

    initBigBar(chatCount, isFirstChat);
    setActivityAnim(isFirstChat);

    FragmentManager fm = getSupportFragmentManager();

    channel = ChannelStore.getChannel();

    topNavFragment = (TopNavFragment) fm.findFragmentById(R.id.f_chat_top_nav);
    topNavFragment.setOnChatTopNavListener(this);

    presenter = new ChatPresenter(this);
    adapter = new ChatAdapter(TextUtils.isEmpty(chatId));

    presenter.setView(this);
    presenter.setAdapterModel(adapter);
    presenter.setAdapterView(adapter);
    presenter.setChatId(chatId);

    layoutManager = new LinearLayoutManager(this);
    layoutManager.setStackFromEnd(true);
    chatList = (ChatRecyclerView) findViewById(R.id.recycler_chat);
    chatList.setLayoutManager(layoutManager);
    chatList.setAdapter(adapter);
    chatList.setItemAnimator(null);
    chatList.getRecycledViewPool().setMaxRecycledViews(MessageType.VERIFY.toInt(), 1);
    chatList.addOnLayoutChangeListener(new View.OnLayoutChangeListener() {
      @Override
      public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (bottom < oldBottom) {
          collapseTopNav(true);

          if (currentPosition == adapter.getItemCount() - 1) {
            chatList.postDelayed(new Runnable() {
              @Override
              public void run() {
                layoutManager.scrollToPosition(currentPosition);
              }
            }, 100);
          }
        }
      }
    });
    chatList.setTopNavFragment(topNavFragment);
    chatList.addOnScrollListener(new InfiniteScrollListener(
        layoutManager,
        InfiniteScrollListener.TOP,
        chatList) {
      @Override
      public void scrolledInList() {}

      @Override
      public void scrollAttachedToBottom() {
        previewFragment.hide();
      }

      @Override
      public void refresh() {
        presenter.fetchBackwardMessages();
      }
    });

    waterMarkLayout = (WaterMarkLayout) findViewById(R.id.chat_layout_water_mark);
    setWaterMarkLayout(channel);

    findViewById(R.id.button_attach).setOnClickListener(this);

    imageSend = (ImageButton) findViewById(R.id.iv_chat_send);
    imageSend.setOnClickListener(this);

    editChat = (WatchedEditText) findViewById(R.id.edit_chat);
    editChat.setWatchedTextChangedListener(this);
    editChat.setOnFocusChangeListener(new View.OnFocusChangeListener() {
      @Override
      public void onFocusChange(View v, boolean hasFocus) {
        adapter.setChatEditTextFocus(hasFocus);
      }
    });
    editChat.setText(PrefSupervisor.getStoredMessage(this));
    PrefSupervisor.clearStoredMessage(this);

    layoutInput = findViewById(R.id.layout_input);
    disabledInputText = findViewById(R.id.text_disabled_input);

    setDisabledInputBoxVisibility(channel, false);

    previewFragment = (PreviewFragment) fm.findFragmentById(R.id.f_chat_preview);
    compltedFragment = (ChatCompltedFragment) fm.findFragmentById(R.id.f_chat_completed);

    BackgroundToucher.makeKeyboardEvent(this, chatList, editChat);

    setStyle();

    presenter.requestPreloadData(chatId);

    typingManager = new TypingManager(chatId, UserChat.CLASSNAME, editChat);

    if (SocketManager.isError()) {
      setReconnectVisibility(true);
    }

    subscribe();

    if (animated) {
      overridePendingTransition(enterAnimInCreate, R.anim.ch_plugin_idle);
    } else {
      overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
    }
  }

  private void setWaterMarkLayout(final Channel channelInfo) {
    if (channelInfo != null && channelInfo.isTrial()) {
      waterMarkLayout.setVisibility(View.VISIBLE);
      waterMarkLayout.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          Executor.goWeb(getBaseContext(),
              String.format(Const.UTM_URL, "plugin_watermark", channelInfo.getName(), channelInfo.getId()));
        }
      });

      chatList.addOnScrollListener(new InfiniteScrollListener(
          layoutManager,
          InfiniteScrollListener.TOP,
          chatList) {

        @Override
        public void scrolledInList() {
          waterMarkLayout.setVisibility(View.GONE);
        }

        @Override
        public void scrollAttachedToBottom() {
          waterMarkLayout.setVisibility(View.VISIBLE);
        }

        @Override
        public void refresh() {}
      });
    } else {
      waterMarkLayout.setVisibility(View.GONE);
      chatList.setPadding(0, 0, 0, 0);
    }
  }

  @Override
  protected void onDestroy() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    if (presenter != null) {
      presenter.release();
    }
    super.onDestroy();
  }

  @Override
  public void finish() {
    if (presenter != null && presenter.getChatId() != null) {
      presenter.leaveChat();
    }
    super.finish();
  }

  private void initBigBar(int chatCount, boolean isFirstChat) {
    getBigBar().withActivity(this)
        .addMenu(
            ActionType.SETTINGS,
            MenuPosition.LEFT,
            isFirstChat ? MenuState.VISIBLE : MenuState.HIDDEN)
        .addMenu(
            ActionType.BACK,
            MenuPosition.LEFT,
            isFirstChat ? MenuState.HIDDEN : MenuState.VISIBLE)
        .addText(MenuPosition.LEFT)
        .addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN)
        .addMenu(ActionType.EXIT, MenuPosition.RIGHT)
        .build();
    getBigBar().setText(chatCount);
  }

  private void setActivityAnim(boolean isFirstChat) {
    if (isFirstChat) {
      enterAnimInCreate = R.anim.ch_plugin_slide_in_bottom;
      existAnimInFinish = R.anim.ch_plugin_slide_out_bottom;
    } else {
      enterAnimInCreate = R.anim.ch_plugin_slide_in_right;
      existAnimInFinish = R.anim.ch_plugin_slide_out_right;
    }
  }

  private void setStyle() {
    Plugin plugin = ChannelStore.getPlugin();

    if (plugin != null) {
      adapter.setColor(plugin.getBackgroundColor(), plugin.getTextColor());

      setStatusBarColor(plugin.getBackgroundColor());
      getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
      getBigBar().setImageLeftOfTitle(R.drawable.ch_plugin_normal_w);
      getBigBar().getImageLeftOfTitle().setVisibility(View.INVISIBLE);
      getBigBar().setImageRightOfTitle(
          plugin.getTextColor() == Color.WHITE
              ? R.drawable.ch_plugin_dropdown_arrow_down
              : R.drawable.ch_plugin_dropdown_arrow_down_b);
    }

    if (channel != null) {
      getBigBar().setTitle(channel.getName());
    }
  }

  private void setDisabledInputBoxVisibility(Channel channel, boolean isSocketEvent) {
    if (channel != null) {
      if (isSocketEvent) {
        if (channel.isWorking() || Const.AWAY_OPTION_ACTIVE.equals(channel.getAwayOption())) {
          setDisabledInputBoxVisibility(false);
        }
      } else {
        if (!channel.isWorking() && Const.AWAY_OPTION_DISABLED.equals(channel.getAwayOption())) {
          setDisabledInputBoxVisibility(true);
        } else {
          setDisabledInputBoxVisibility(false);
        }
      }
    } else {
      setDisabledInputBoxVisibility(false);
    }
  }

  private void setDisabledInputBoxVisibility(boolean isDisabled) {
    disabledInputText.setVisibility(UIUtils.getVisible(isDisabled, true));
    layoutInput.setVisibility(UIUtils.getVisible(!isDisabled, true));
  }

  private void subscribe() {
    subscription = RxBus.observable().subscribe(new Action1<Object>() {
      @Override
      public void call(Object o) {
        if (o != null) {
          if (o instanceof TopNavBus.Change) {
            changeBigBar(((TopNavBus.Change) o).expand);
          }
        }
      }
    });
  }

  private void changeBigBar(boolean expand) {
    Plugin plugin = ChannelStore.getPlugin();
    UserChat userChat = presenter.getUserChat();
    BigBar bigBar = getBigBar();

    bigBar.getImageRightOfTitle().setRotation(expand ? -180f : 0f);

    if (userChat == null || userChat.isStateReady() || userChat.isStateOpen()) {
      bigBar.setImageLeftOfTitle(ChatResponseManager.getResponseSymbol(plugin, channel));
      bigBar.setTitle(channel == null
          ? ResUtils.getString(this, "ch.unknown")
          : channel.getName());
      bigBar
          .setSubTitleByKey(ChatResponseManager.getShortResponseDescriptionKey(channel))
          .setSubTitleVisibility(!expand);
    } else {
      ProfileEntity entity = ChatDataDictionary.getInstance()
          .getProfile(userChat.getHostType(), userChat.getHostId());

      bigBar.setImageLeftOfTitle(ChatResponseManager.getManagerOnlineSymbol(plugin, entity));
      bigBar.setTitle(entity == null ? "" : entity.getName());
      bigBar.setSubTitleVisibility(false);
    }

    if (expand) {
      bigBar.getImageLeftOfTitle().setVisibility(View.INVISIBLE);
    }
  }

  @Override
  public void onLoadUserChat(UserChat userChat, boolean create) {
    ChatDataDictionary dictionary = ChatDataDictionary.getInstance();

    if (userChat != null) {
      typingManager.setChatId(userChat.getId());
    }

    if (userChat == null || userChat.isStateReady() || userChat.isStateOpen()) {
      topNavFragment.set(dictionary.getFollingManagers());

      if (userChat == null) {
        expandTopNav(false);
      } else {
        collapseTopNav(true);
        getBigBar().setMenuState(ActionType.BACK, MenuState.VISIBLE);
        getBigBar().setMenuState(ActionType.SETTINGS, MenuState.HIDDEN);
      }
    } else {
      ProfileEntity profileEntity = dictionary.getProfile(userChat.getHostType(), userChat.getHostId());
      if (profileEntity == null) {
        profileEntity = UserChatListDataDictionary.getInstance().getProfile(userChat.getHostType(), userChat.getHostId());
      }

      topNavFragment.set(profileEntity);
      collapseTopNav(true);

      getBigBar().setMenuState(ActionType.BACK, MenuState.VISIBLE);
      getBigBar().setMenuState(ActionType.SETTINGS, MenuState.HIDDEN);
    }
    getBigBar().setOnClickListener(this);
  }

  @Override
  public void updateBackwardId(String backwardId) {
    chatList.setBackwardId(backwardId);
  }

  @Override
  public void setInputLayoutVisibility() {
    if (presenter.isStateCompleted()) {
      Keyboard.close(this, editChat);

      compltedFragment.show(editChat.getText().toString().trim());
      layoutInput.setVisibility(View.GONE);
      disabledInputText.setVisibility(View.GONE);
    } else {
      compltedFragment.hide();
      layoutInput.setVisibility(View.VISIBLE);
      disabledInputText.setVisibility(View.GONE);
    }
  }

  @Override
  public boolean isMovableToBottomPosition() {
    int lastPosition = layoutManager.findLastVisibleItemPosition();
    return lastPosition <= adapter.getItemCount() - 2 && lastPosition >= adapter.getItemCount() - 4;
  }

  @Override
  public boolean isBottomPosition() {
    return layoutManager.findLastCompletelyVisibleItemPosition() >= adapter.getItemCount() - 2;
  }

  @Override
  public void scrollToPostion(int position) {
    layoutManager.scrollToPosition(position);
  }

  @Override
  public void scrollToBottom(boolean force) {
    if (layoutManager.findLastCompletelyVisibleItemPosition() == adapter.getItemCount() - 2 || force) {
      layoutManager.scrollToPosition(adapter.getItemCount() - 1);
    }
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    super.onActivityResult(requestCode, resultCode, data);
    switch (requestCode) {
      case Const.PHOTO_REQUEST_CODE:
        if (resultCode == Const.PHOTO_RESULT_CODE) {
          presenter.sendImageFiles(data.getStringArrayListExtra(Const.PHOTO_INTENT_KEY));
          collapseTopNav(true);
        }
        break;

      case Const.REQUEST_PHOTO_ALBUM:
        PhotoAlbumStorage.getInstance().release();
        break;

      case Const.REQUEST_PLUGIIN_SETTINGS:
        if (resultCode == Const.RESULT_CHAT_OPTION_CHANGED) {
          setResult(Const.RESULT_CHAT_OPTION_CHANGED);
        }
        break;
    }
  }

  @Override
  protected void receiveRxEvent(Object o) {
    super.receiveRxEvent(o);
    if (o instanceof LinkableMessageBus) {
      LinkableMessageBus linkable = (LinkableMessageBus) o;
      onClickLinkableMessage(linkable.getMessage(), linkable.getLinkType());
    }
  }

  @Override
  public void receiveCommand(Command command, Object object) {
    presenter.receiveCommand(command, object);
  }

  @Override
  public void receiveData(ChannelModel channelModel, boolean upsert) {
    presenter.receiveData(channelModel, upsert);
  }

  @Override
  public void receiveChatCounter(int count) {
    if (count > 0) {
      getBigBar().setMenuState(ActionType.BACK, MenuState.VISIBLE);
      getBigBar().setMenuState(ActionType.SETTINGS, MenuState.HIDDEN);
    }

    getBigBar().setText(count);
  }

  @Override
  public void receiveTyping(Typing typing) {
    if (typing != null
        && typing.isOther()
        && typing.isSameChat(presenter.getChatId(), UserChat.CLASSNAME)) {
      typingManager.addTTLTimer(typing);

      presenter.receiveTyping(typing);
    }
  }

  @Override
  public void receiveLanguageEvent() {
    presenter.receiveLanguageEvent();
  }

  @Override
  public void optionClicked(ActionType actionType) {
    switch (actionType) {
      case REFRESH:
        presenter.refresh();
        break;
      case SETTINGS:
        IntentUtils.setNextActivity(this, SettingsActivity.class)
            .startActivityForResult(Const.REQUEST_PLUGIIN_SETTINGS);
        break;
      case BACK:
        existAnimInFinish = R.anim.ch_plugin_slide_out_right;
        finish();
        break;
      case EXIT:
        existAnimInFinish = R.anim.ch_plugin_slide_out_bottom;
        setResult(Const.RESULT_CHAT_GO_TO_MAIN);
        finish();
        break;
    }
  }

  @Override
  public void setRefreshVisibility(boolean showRefresh) {
    getBigBar().setMenuState(ActionType.REFRESH, showRefresh ? MenuState.VISIBLE : MenuState.HIDDEN);
  }

  @Override
  public void setReconnectVisibility(boolean show) {
    topNavFragment.setReconnectVisibility(show);
  }

  @Override
  public void setChannel(Channel channel) {
    changeBigBar(topNavFragment.isExpand());
    setDisabledInputBoxVisibility(channel, true);

    topNavFragment.setChannel(channel);
    if (topNavFragment.isExpand()) {
      chatList.setTranslationY(topNavFragment.getExpectHeight());
    }
  }

  @Override
  public void changeBigBar() {
    changeBigBar(topNavFragment.isExpand());
  }

  @Override
  public void processNewMessage(ProfileEntity profileEntity, Message message) {
    if (profileEntity == null || message == null || message.getLog() != null) {
      return;
    }

    if (layoutManager.canScrollVertically() && !isBottomPosition()) {
      previewFragment.show(profileEntity);
    }
  }

  @Override
  public void setProfileEntity(ProfileEntity profileEntity) {
    topNavFragment.set(profileEntity);

    if (topNavFragment.isExpand()) {
      chatList.setTranslationY(topNavFragment.getExpectHeight());
    }
  }

  @Override
  public void onRemovedChat() {
    finish();
  }

  @Override
  public void onWatchedTextChanged(String s) {
    imageSend.setEnabled(!TextUtils.isEmpty(s.trim()));
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();

    if (id == R.id.button_attach) {
      hideKeyboard(editChat);
      IntentUtils.setNextActivity(ChatActivity.this, PhotoPickerActivity.class)
          .startActivityForResult(Const.PHOTO_REQUEST_CODE);
    }
    if (id == R.id.iv_chat_send) {
      presenter.sendTextMessage(editChat.getString());
      editChat.setText("");

      topNavFragment.collapse();
    }
    if (id == R.id.big_bar) {
      if (chatList.isScrolling()) {
        return;
      }

      if (topNavFragment.isExpand()) {
        collapseTopNav(true);
      } else {
        expandTopNav(true);
      }
    }
  }

  private void collapseTopNav(boolean immediately) {
    new Handler().postDelayed(new Runnable() {
      @Override
      public void run() {
        topNavFragment.collapse();
        chatList.setTranslationY(0, true);
      }
    }, immediately ? 0 : DELAY_EXPAND_COLLAPSE);
  }

  private void expandTopNav(boolean immediately) {
    new Handler().postDelayed(new Runnable() {
      @Override
      public void run() {
        int topNavHeight = topNavFragment.getExpectHeight();
        hideKeyboard(editChat);

        topNavFragment.setTranslationY(-topNavHeight);
        topNavFragment.expand();

        if (chatList.canScrollVertically(ChatRecyclerView.DIRECTION_SCROLLING_DOWN)) {
          changeBigBar(true);
        } else {
          changeBigBar(topNavHeight > 0);
        }
      }
    }, immediately ? 0 : DELAY_EXPAND_COLLAPSE);
  }

  @Override
  public void onClickTopNav() {
    if (chatList.isScrolling()) {
      return;
    }
    topNavFragment.collapse();
  }

  @Override
  public void onFileDownload(Message message) {
    File file = message.getFile();
    if (file.getType() != null && file.getType().startsWith("video")) {
      IntentUtils.setNextActivity(this, VideoViewerActivity.class)
          .putExtra(Const.EXTRA_FILE_NAME, file.getName())
          .putExtra(Const.EXTRA_URL, file.getUrl())
          .startActivity();
    } else {
      IntentUtils.setNextActivity(this, DownloadActivity.class)
          .putExtra(Const.EXTRA_URL, file.getUrl())
          .putExtra(Const.EXTRA_FILE_NAME, file.getFilename())
          .putExtra(Const.EXTRA_IMAGE, file.isImage())
          .startActivity();
    }
  }

  @Override
  public void onShowPhotoAlbum(File file) {
    IntentUtils.setNextActivity(this, PhotoAlbumActivity.class)
        .putExtra(Const.EXTRA_FILE_ID, file.getId())
        .startActivityForResult(Const.REQUEST_PHOTO_ALBUM);
  }

  @Override
  public void onUrlClicked(String url) {
    boolean handle = false;
    List<ChannelPluginListener> listeners = ChannelIO.getChannelPluginListeners();

    if (listeners.isEmpty()) {
      IntentUtils.setUrl(this, url).startActivity();
    } else {
      for (ChannelPluginListener listener : listeners) {
        handle = listener.onClickChatLink(url);
        if (!handle) {
          IntentUtils.setUrl(this, url).startActivity();
        }
      }
    }
  }

  private void onClickLinkableMessage(String linkText, LinkType linkType) {
    switch (linkType) {
      case URL:
        onUrlClicked(linkText);
        break;

      case PHONE:
        IntentUtils.setPhone(this, linkText).startActivity();
        break;

      case EMAIL:
        IntentUtils.setEmail(this, linkText).startActivity();
        break;
    }
  }

  @Override
  public void onChangeProfileMessageFocus(boolean hasFocus) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
      layoutInput.setBackground(ContextCompat.getDrawable(this,
          hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
    } else {
      layoutInput.setBackgroundDrawable(ContextCompat.getDrawable(this,
          hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
    }
  }

  @Override
  public void onBackPressed() {
    if (isFirstChat) {
      setResult(Const.RESULT_CHAT_GO_TO_MAIN);
    }
    finish();
  }

  @Override
  public void requestFocusEditText() {
    editChat.requestFocus();
  }

  @Override
  public void sendingMessageClicked(final SendingMessageItem item) {
    final AlertDialog dialog = new AlertDialog.Builder(this)
        .setMessage(ResUtils.getString(this, "ch.chat.resend.description"))
        .setPositiveButton(ResUtils.getString(this, "ch.chat.retry_sending_message"), new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            presenter.resend(item);
          }
        })
        .setNegativeButton(ResUtils.getString(this, "ch.chat.resend.cancel"), null)
        .setNeutralButton(ResUtils.getString(this, "ch.chat.delete"), new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            presenter.removeFailedItem(item);
          }
        })
        .setCancelable(true)
        .create();

    dialog.setOnShowListener(new DialogInterface.OnShowListener() {
      @Override
      public void onShow(DialogInterface args) {
        int dark = ContextCompat.getColor(ChatActivity.this, R.color.ch_dark);
        int cobalt = ContextCompat.getColor(ChatActivity.this, R.color.ch_cobalt);

        dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(cobalt);
        dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(dark);
        dialog.getButton(AlertDialog.BUTTON_NEUTRAL).setTextColor(dark);
      }
    });
    dialog.show();
  }

  @Override
  @AnimRes
  protected int getEnterAnimOfCreate() {
    return enterAnimInCreate;
  }

  @Override
  @AnimRes
  protected int getExistAnimOfFinish() {
    return existAnimInFinish;
  }
}