package com.zoyi.channel.plugin.android.activity.base;

import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UpdatedModel;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2016. 12. 20..
 */
public abstract class BaseDictionary {

  protected Map<String, Manager> managerMap;
  protected Map<String, Bot> botMap;

  public BaseDictionary() {
    managerMap = new HashMap<>();
    botMap = new HashMap<>();
  }

  public void release() {
    if (managerMap != null) {
      managerMap.clear();
    }
    if (botMap != null) {
      botMap.clear();
    }
  }

  protected abstract  <E extends ChannelModel> E get(Class<E> clazz, String id);
  protected abstract void add(List<? extends ChannelModel> channelModels);
  protected abstract void remove(ChannelModel channelModel);

  public void add(ChannelModel channelModel) {
    add(Collections.singletonList(channelModel));
  }

  protected boolean checkCanUpdate(ChannelModel channelModel) {
    if (channelModel instanceof UpdatedModel) {
      ChannelModel model = get(channelModel.getClass(), channelModel.getId());
      if (model == null) {
        return true;
      } else if (model instanceof UpdatedModel) {
        UpdatedModel oldbie = (UpdatedModel) model;
        UpdatedModel newbie = (UpdatedModel) channelModel;

        return CompareUtils.compare(oldbie.getUpdatedAt(), newbie.getUpdatedAt()) < 0;
      }
    }
    return true;
  }

  public ProfileEntity getProfile(String personType, String personId) {
    if (personType == null || personId == null) {
      return null;
    }
    switch (personType) {
      case Manager.CLASSNAME:
        return managerMap.get(personId);
      case Bot.CLASSNAME:
        return botMap.get(personId);
      default:
        return null;
    }
  }
}
