package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.DisplayMetrics;

import java.util.Locale;

/**
 * Created by mika on 2016. 4. 19..
 */
public class Utils {
  public static int addBlackMask(int color) {
    float[] hsv = new float[3];
    Color.colorToHSV(color, hsv);
    hsv[2] = Math.max(0, hsv[2] - 0.2f);
    return Color.HSVToColor(hsv);
  }

  public static Point getCorrectImageSize(
      int screenWidth,
      int screenHeight,
      int picWidth,
      int picHeight) {
    double ratioWidth = 1.0;
    double ratioHeight = 1.0;

    int width = picWidth;
    int height = picHeight;

    if (screenWidth == 0 || screenHeight == 0) {
      return new Point(picWidth, picHeight);
    }

    int minWidth = screenWidth / 10;
    int maxWidth = screenWidth * 6 / 10;
    int minHeight = screenHeight / 10;
    int maxHeight = screenHeight * 5 / 10;

    if (picWidth > maxWidth) {
      ratioWidth = (double) maxWidth / picWidth;
    } else if (picWidth < minWidth) {
      ratioWidth = (double) minWidth / picWidth;
    }

    if (picHeight > maxHeight) {
      ratioHeight = (double) maxHeight / picHeight;
    } else if (picHeight < minWidth) {
      ratioHeight = (double) minHeight / picHeight;
    }

    if (ratioWidth > 1.0 && ratioHeight < 1.0) {
      return new Point(minWidth, maxHeight);
    }
    if (ratioWidth < 1.0 && ratioHeight > 1.0) {
      return new Point(maxWidth, minHeight);
    }

    if (ratioWidth < 1.0) {
      double ratioMin = Math.min(ratioWidth, ratioHeight);
      width = Math.max(minWidth, (int) (picWidth * ratioMin));
      height = Math.max(minHeight, (int) (picHeight * ratioMin));
    } else if (ratioWidth > 1.0) {
      double ratioMax = Math.max(ratioWidth, ratioHeight);
      width = Math.min(maxWidth, (int) (picWidth * ratioMax));
      height = Math.min(maxHeight, (int) (picHeight * ratioMax));
    }
    return new Point(width, height);
  }

  public static String getProperBytes(long bytes) {
    if (bytes < 1000) {
      return String.format(Locale.US, "%dB", bytes);
    } else if (bytes <= 1000000) {
      return String.format(Locale.US, "%.1fKB", bytes / 1000.0);
    } else if (bytes <= 1000000000) {
      return String.format(Locale.US, "%.1fMB", bytes / 1000000.0);
    } else {
      return String.format(Locale.US, "%.1fGB", bytes / 1000000000.0);
    }
  }

  public static float dpToPx(Context context, float dp) {
    Resources resources = context.getResources();
    DisplayMetrics metrics = resources.getDisplayMetrics();
    return dp * ((float) metrics.densityDpi / DisplayMetrics.DENSITY_DEFAULT);
  }

  public static String getCount(int count, boolean emptyIfZero) {
    return getCount((long) count, emptyIfZero);
  }

  public static String getCount(long count, boolean emptyIfZero) {
    if (count <= 0 && emptyIfZero) {
      return "";
    }
    return count >= 1000 ? "999+" : String.valueOf(count);
  }

  public static Spanned getHtmlFormattedText(String text) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
      return Html.fromHtml(text, Html.FROM_HTML_MODE_LEGACY);
    }
    return Html.fromHtml(text);
  }
}
