package com.zoyi.channel.plugin.android.activity.chat;

import com.zoyi.channel.plugin.android.activity.base.BaseDictionary;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumberItem;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.util.CountryUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2016. 12. 8..
 */
public class ChatDataDictionary extends BaseDictionary {

  private static ChatDataDictionary instance;
  public static ChatDataDictionary getInstance() {
    if (instance == null) {
      synchronized (ChatDataDictionary.class) {
        if (instance == null) {
          instance = new ChatDataDictionary();
        }
      }
    }
    return instance;
  }

  private List<Manager> follingManagers;
  private String userName;
  private MobileNumberItem userMobilNumber;

  private ChatDataDictionary() {
    super();
    follingManagers = new ArrayList<>();
    userMobilNumber = new MobileNumberItem(CountryUtils.getDefaultCountryCode(), "", -1);
  }

  @Override
  public void release() {
    super.release();
    if (follingManagers != null) {
      follingManagers.clear();
    }
    userName = null;
    userMobilNumber = new MobileNumberItem(CountryUtils.getDefaultCountryCode(), "", -1);
  }

  @Override
  public <E extends ChannelModel> E get(Class<E> clazz, String id) {
    if (id != null) {
      String className = clazz.getSimpleName();
      switch (className) {
        case Manager.CLASSNAME:
          return (E) managerMap.get(id);

        case Bot.CLASSNAME:
          return (E) botMap.get(id);
      }
    }
    return null;
  }

  @Override
  public void add(List<? extends ChannelModel> channelModels) {
    if (channelModels != null) {
      for (ChannelModel channelModel : channelModels) {
        if (checkCanUpdate(channelModel)) {
          String className = channelModel.getClass().getSimpleName();
          switch (className) {
            case Manager.CLASSNAME:
              managerMap.put(channelModel.getId(), (Manager) channelModel);
              break;

            case Bot.CLASSNAME:
              botMap.put(channelModel.getId(), (Bot) channelModel);
              break;
          }
        }
      }
    }
  }

  @Override
  protected void remove(ChannelModel channelModel) {
    // do nothing...
  }

  public void setFollowingManagers(List<Manager> managers) {
    this.follingManagers = managers;
  }

  public List<Manager> getFollingManagers() {
    return follingManagers;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public void setUserMobilNumber(MobileNumberItem userMobilNumber) {
    this.userMobilNumber = userMobilNumber;
  }

  public String getUserName() {
    return userName;
  }

  public MobileNumberItem getUserMobilNumber() {
    return userMobilNumber;
  }
}
