/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.ActionTransaction;
import com.splunk.mint.ActionTransactionStart;
import com.splunk.mint.DataSaver;
import com.splunk.mint.EnumTransactionStatus;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ActionTransactionStop
extends ActionTransaction
implements InterfaceDataType {
    protected long duration = 0L;
    protected byte status = 1;
    protected String reason = "";

    public ActionTransactionStop(ActionTransaction txStart, byte status, String reason, HashMap<String, Object> customData) {
        super(txStart.transaction_id, txStart.name, (byte)5, customData);
        this.status = status;
        this.reason = reason == null || reason.length() == 0 ? "NA" : reason;
        this.duration = this.timestampMilis - txStart.timestampMilis;
    }

    protected static final ActionTransactionStop createTransactionStop(String id, HashMap<String, Object> customData) {
        return ActionTransactionStop.createTransactionStop(id, (byte)0, null, customData);
    }

    protected static final ActionTransactionStop createTransactionCancel(String id, String reason, HashMap<String, Object> customData) {
        return ActionTransactionStop.createTransactionStop(id, (byte)2, reason, customData);
    }

    protected static final ActionTransactionStop createTransactionFail(String id, String errorHash, HashMap<String, Object> customData) {
        return ActionTransactionStop.createTransactionStop(id, (byte)1, errorHash, customData);
    }

    static final ActionTransactionStop createTransactionStop(String id, byte status, String reason, HashMap<String, Object> customData) {
        ActionTransactionStart startedTransaction = Properties.startedTransactions.getTransaction(id);
        if (startedTransaction == null) {
            return null;
        }
        ActionTransactionStop stoppedTransaction = new ActionTransactionStop(startedTransaction, status, reason, customData);
        Properties.startedTransactions.closeTransaction(startedTransaction);
        return stoppedTransaction;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getJson();
        try {
            json.put("status", (Object)EnumTransactionStatus.getStringFromEnum(this.status));
            json.put("reason", (Object)this.reason);
            json.put("tr_duration", this.duration);
            this.AddSelfToTransactions(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator((byte)5);
    }

    void AddSelfToTransactions(JSONObject json) {
        try {
            JSONArray transactions = json.getJSONArray("transactions");
            transactions.put((Object)this.getJsonWithoutBaseDTO());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(boolean saveOnFail) {
        String trData = this.toJsonLine();
        if (trData != null) {
            NetSender.send(trData, saveOnFail);
        }
    }

    @Override
    public void save() {
        String trData = this.toJsonLine();
        if (trData != null) {
            DataSaver.save(trData);
        }
    }

    @Override
    public void send(Context ctx, boolean saveOnFail) {
        String trData = this.toJsonLine();
        if (trData != null) {
            NetSender.send(trData, saveOnFail);
        }
    }
}

