/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TextMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.BitmapRequestBuilder;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;

public class ImageMessageHolder
extends TextMessageHolder
implements View.OnClickListener {
    private Context context;
    MaskableFrameLayout imageLayout;
    ImageView imagePlaceholder;
    ImageView imageContent;
    private Point previewSize;
    private Message message;
    private OnMessageClickListener listener;

    public static ImageMessageHolder newInstance(ViewGroup parent, MessageType messageType, OnMessageClickListener listener) {
        return new ImageMessageHolder(ImageMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public ImageMessageHolder(View itemView, MessageType messageType, OnMessageClickListener listener) {
        super(itemView, messageType);
        this.context = itemView.getContext();
        this.listener = listener;
        this.imageLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_message_content_image);
        this.imagePlaceholder = (ImageView)itemView.findViewById(R.id.image_placeholder);
        this.imageContent = (ImageView)itemView.findViewById(R.id.image_chat);
    }

    @Override
    public void bind(ChatMessageItem item, boolean isConnectedMessage) {
        File file;
        super.bind(item, isConnectedMessage);
        this.message = item.getMessage();
        if (this.message != null && (file = this.message.getFile()) != null) {
            this.setImageMessage(file.getPreviewThumb(), false, this.message.getMessage());
        }
    }

    protected void setImageMessage(PreviewThumb previewThumb, boolean isWebPage, String message) {
        int width = 0;
        int height = 0;
        this.previewSize = new Point();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        Point windowSize = new Point();
        wm.getDefaultDisplay().getSize(windowSize);
        if (isWebPage) {
            width = windowSize.x - (int)Utils.dpToPx(this.context, 146.0f);
            height = (int)((double)width * 0.52);
            this.previewSize.set(width, height);
        } else {
            this.previewSize = Utils.getCorrectImageSize(windowSize.x, windowSize.y, previewThumb.getWidth(), previewThumb.getHeight());
            width = Math.max(this.previewSize.x, 1);
            height = Math.max(this.previewSize.y, 1);
        }
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.imageLayout.getLayoutParams();
        params.width = width;
        params.height = height;
        int marginTop = (int)Utils.dpToPx(this.context, !TextUtils.isEmpty((CharSequence)message) ? 10.0f : 0.0f);
        int marginBottom = (int)Utils.dpToPx(this.context, 4.0f);
        params.setMargins(0, marginTop, 0, marginBottom);
        this.imageLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.imageLayout.setOnClickListener(this);
        this.imageLayout.setVisibility(0);
        this.imagePlaceholder.setVisibility(0);
        ((BitmapRequestBuilder)((BitmapRequestBuilder)((BitmapRequestBuilder)((BitmapRequestBuilder)Glide.with(this.itemView.getContext()).load(previewThumb.getUrl()).asBitmap().override(width, height)).dontAnimate()).centerCrop()).listener(new RequestListener<String, Bitmap>(){

            @Override
            public boolean onException(Exception e, String model, Target<Bitmap> target, boolean isFirstResource) {
                return false;
            }

            @Override
            public boolean onResourceReady(Bitmap resource, String model, Target<Bitmap> target, boolean isFromMemoryCache, boolean isFirstResource) {
                ImageMessageHolder.this.imagePlaceholder.setVisibility(8);
                return false;
            }
        })).into(this.imageContent);
    }

    protected Point getPreviewSize() {
        return this.previewSize;
    }

    public void onClick(View v) {
        if (this.message != null) {
            this.listener.messageClicked(this.message);
        }
    }
}

