package com.zoyi.channel.plugin.android.presenter.chat;

import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.interfaces.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.presenter.BasePresenter;
import com.zoyi.channel.plugin.android.presenter.BaseView;

import java.util.ArrayList;

public interface ChatContract {

  interface View extends BaseView<Presenter> {

    void onLoadUserChat(UserChat userChat, boolean create);
    void updateBackwardId(String backwardId);
    void setInputLayoutVisibility();
    boolean isMovableToBottomPosition();
    boolean isBottomPosition();
    void scrollToBottom(boolean force);
    void scrollToPostion(int position);
    void setRefreshVisibility(boolean showRefresh);
    void processNewMessage(ProfileEntity profileEntity, Message message);
    void setProfileEntity(ProfileEntity profileEntity);
    void onRemovedChat();
    void onFileDownload(Message message);
    void onShowPhotoAlbum(File file);
    void onUrlClicked(String url);
    void sendingMessageClicked(SendingMessageItem item);
    void onChangeProfileMessageFocus(boolean hasFocus);
    void setReconnectVisibility(boolean show);
    void setChannel(Channel channel);
    void changeBigBar();
    void requestFocusEditText();
  }

  interface Presenter extends BasePresenter<View> {

    void release();
    UserChat getUserChat();
    String getChatId();
    boolean isStateCompleted();
    void setChatId(String chatId);
    void setAdapterView(ChatAdapterContract.View adapterView);
    void setAdapterModel(ChatAdapterContract.Model adapterModel);
    void requestPreloadData(String chatId);
    void fetchUserChat();
    void fetchMessages();
    boolean isMessageExists();
    void fetchInitMessages(final int count);
    void fetchForwardMessages(String since, final int count);
    void fetchBackwardMessages();
    void sendTextMessage(String message);
    void sendImageFiles(ArrayList<String> imagePaths);
    void receiveData(ChannelModel channelModel, boolean upsert);
    void receiveCommand(Command command, Object object);
    void receiveTyping(Typing typing);
    void receiveLanguageEvent();
    void resend(SendingMessageItem item);
    void removeFailedItem(SendingMessageItem item);
    void refresh();
    void leaveChat();
  }

}
