package com.zoyi.channel.plugin.android.presenter.chat;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageReviewListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

import java.util.Collection;
import java.util.List;

public interface ChatAdapterContract {

  interface View {

    void setOnMessageClickListener(OnMessageClickListener onMessageClickListener);
    void setOnSendingMessageClickListener(OnSendingMessageClickListener onSendingMessageClickListener);
    void setOnMessageReviewListener(OnMessageReviewListener onMessageReviewListener);
    void setOnProfileUpdateListener(OnProfileUpdateListener onProfileUpdateListener);
  }

  interface Model {

    void setUserChat(UserChat userChat);

    MessageItem getItem(int index);

    void addMessage(Message message, String chatId);
    void addMessages(List<Message> messages, String chatId);

    void addMessageItem(MessageItem item);
    void addMessageItems(Collection<MessageItem> items);
    void removeMessageItem(MessageItem item);
    void addOrUpdateMessageItem(int position, MessageItem item);
    void addMessageItem(UserChat userChat);

    int getIndex(MessageItem item);
    String getLastMessageItemId();
    void setImageFilesToStorage();

    ActionMessageItem getWelcomeMessage();
    void setWelcomeMessage(ActionMessageItem welcomeMessage);
  }

}
