package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.content.SharedPreferences;

import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.model.rest.Veil;

import java.util.Map;

public class CheckInPrefSupervisor {

  private static final String CHECK_IN_PREF = "CheckInPreferences";

  private static final String HAS_CHECK_IN_DATA = "hasCheckInData";
  private static final String USER_ID = "userId";
  private static final String NAME = "name";
  private static final String AVATAR_URL = "avatarUrl";
  private static final String MOBILE_NUMBER = "mobileNumber";

  public static Profile getProfile(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    Profile profile = Profile.create();
    Map<String, ?> datas = preferences.getAll();

    for (Map.Entry<String, ?> entry : datas.entrySet()) {
      if (USER_ID.equals(entry.getKey())) {
        profile.setName(String.valueOf(entry.getValue()));
      } else if (NAME.equals(entry.getKey())) {
        profile.setName(String.valueOf(entry.getValue()));
      } else if (AVATAR_URL.equals(entry.getKey())) {
        profile.setAvatarUrl(String.valueOf(entry.getValue()));
      } else if (MOBILE_NUMBER.equals(entry.getKey())) {
        profile.setMobileNumber(String.valueOf(entry.getValue()));
      } else {
        Object value = entry.getValue();

        if (value instanceof String) {
          profile.setProperty(entry.getKey(), String.valueOf(value));
        } else if (value instanceof Integer) {
          profile.setProperty(entry.getKey(), (Integer) value);
        } else if (value instanceof Long) {
          profile.setProperty(entry.getKey(), (Long) value);
        } else if (value instanceof Boolean) {
          if (!entry.getKey().equals(HAS_CHECK_IN_DATA)) {
            profile.setProperty(entry.getKey(), (Boolean) value);
          }
        }
      }
    }
    return profile;
  }

  public static void setProfile(Context context, String userId, Profile profile) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    SharedPreferences.Editor editor = preferences.edit();

    if (profile != null) {
      editor.putBoolean(HAS_CHECK_IN_DATA, true);
      editor.putString(USER_ID, userId);
      editor.putString(NAME, profile.getName());
      editor.putString(AVATAR_URL, profile.getAvatarUrl());
      editor.putString(MOBILE_NUMBER, profile.getMobileNumber());

      Map<String, Object> meta = profile.getProperty();

      for (Map.Entry<String, ?> entry : meta.entrySet()) {
        Object value = entry.getValue();

        if (value != null) {
          if (value instanceof String) {
            editor.putString(entry.getKey(), String.valueOf(value));
          } else if (value instanceof Integer) {
            editor.putInt(entry.getKey(), (Integer) value);
          } else if (value instanceof Long) {
            editor.putLong(entry.getKey(), (Long) value);
          } else if (value instanceof Boolean) {
            editor.putBoolean(entry.getKey(), (Boolean) value);
          }
        }
      }
    }
    editor.apply();
  }

  public static void setVeil(Context context, Veil veil) {
    if (veil != null) {
      SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
      SharedPreferences.Editor editor = preferences.edit();

      editor.putBoolean(HAS_CHECK_IN_DATA, true);
      editor.putString(USER_ID, veil.getId());

      editor.apply();
    }
  }

  private static void setValue(Context context, String key, String value) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    SharedPreferences.Editor editor = preferences.edit();

    editor.putString(key, value);

    editor.apply();
  }

  public static void setName(Context context, String name) {
    setValue(context, NAME, name);
  }

  public static void setMobileNumber(Context context, String mobileNumber) {
    setValue(context, MOBILE_NUMBER, mobileNumber);
  }

  public static String getPersonId(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);

    return preferences.getString(USER_ID, null);
  }

  public static boolean hasCheckInData(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);

    return preferences.getBoolean(HAS_CHECK_IN_DATA, false);
  }

  public static void clear(Context context) {
    SharedPreferences preferences = context.getSharedPreferences(CHECK_IN_PREF, Context.MODE_PRIVATE);
    SharedPreferences.Editor editor = preferences.edit();

    editor.clear();
    editor.apply();
  }

}
