package com.zoyi.channel.plugin.android.deserializer;

import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.JsonDeserializationContext;
import com.zoyi.com.google.gson.JsonDeserializer;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonParseException;

import java.lang.reflect.Type;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class MessageDeserializer implements JsonDeserializer {

  private Gson gson;
  private MessageParser messageParser;

  public MessageDeserializer() {
    this.gson = new Gson();
    this.messageParser = MessageParser.create();
  }
  @Override
  public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
    Message message = gson.fromJson(json, type);

    if (message != null) {
      if (message.getMessage() != null) {
        SpannableStringBuilder formattedMessage = messageParser.parse(message.getMessage());
        String formattedStringMessage = formattedMessage.toString();

        message.setFormattedSpanMessage(formattedMessage);
        message.setFormattedStringMessage(formattedStringMessage);
      }
    }
    return message;
  }
}
