package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by mika on 2016. 12. 9..
 */
public class ManagerMessageHolder extends ChatMessageHolder {

  Context context;
  AvatarLayout avatar;
  CHTextView textName;

  public ManagerMessageHolder(
      View itemView,
      OnMessageClickListener listener) {
    super(itemView, listener);

    context = itemView.getContext();
    avatar = (AvatarLayout) itemView.findViewById(R.id.message_avatar);
    textName = itemView.findViewById(R.id.message_name);
  }

  protected void setProfile(ProfileEntity profile) {
    avatar.set(profile);
    if (profile == null) {
      textName.setTextByKey("ch.unknown");
    } else {
      textName.setText(profile.getName());
    }
  }

  public void set(ChatMessageItem item, boolean isContext) {
    ProfileEntity profile = ChatDataDictionary.getInstance()
        .getProfile(item.getPersonType(), item.getPersonId());

    super.set(item.getMessage(), isContext);
    setProfile(profile);
  }
}
