/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.LanguageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;

public class CHTextView
extends AppCompatTextView {
    private Context context;
    private String textKey;
    private Subscription subscription;

    public CHTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        this.subscribe();
        this.setTypeArray(attrs);
    }

    private void setTypeArray(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
            this.textKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_key);
            this.setTextByKey(this.textKey);
        }
    }

    private void subscribe() {
        this.subscription = RxBus.observable().onBackpressureBuffer().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                CHTextView.this.onReceiveEvent(o);
            }
        });
    }

    private void onReceiveEvent(Object object) {
        if (object instanceof LanguageBus && this.textKey != null) {
            this.setTextByKey(this.textKey);
        }
    }

    public void setTextByKey(String key) {
        if (key != null) {
            this.textKey = key;
            super.setText((CharSequence)ResUtils.getString(this.context, key));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        super.onDetachedFromWindow();
    }
}

