/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.DisplayMetrics;
import java.util.Locale;

public class Utils {
    public static int addBlackMask(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = Math.max(0.0f, hsv[2] - 0.2f);
        return Color.HSVToColor((float[])hsv);
    }

    public static Point getCorrectImageSize(int screenWidth, int screenHeight, int picWidth, int picHeight) {
        double ratioWidth = 1.0;
        double ratioHeight = 1.0;
        int width = picWidth;
        int height = picHeight;
        if (screenWidth == 0 || screenHeight == 0) {
            return new Point(picWidth, picHeight);
        }
        int minWidth = screenWidth / 10;
        int maxWidth = screenWidth * 6 / 10;
        int minHeight = screenHeight / 10;
        int maxHeight = screenHeight * 5 / 10;
        if (picWidth > maxWidth) {
            ratioWidth = (double)maxWidth / (double)picWidth;
        } else if (picWidth < minWidth) {
            ratioWidth = (double)minWidth / (double)picWidth;
        }
        if (picHeight > maxHeight) {
            ratioHeight = (double)maxHeight / (double)picHeight;
        } else if (picHeight < minWidth) {
            ratioHeight = (double)minHeight / (double)picHeight;
        }
        if (ratioWidth > 1.0 && ratioHeight < 1.0) {
            return new Point(minWidth, maxHeight);
        }
        if (ratioWidth < 1.0 && ratioHeight > 1.0) {
            return new Point(maxWidth, minHeight);
        }
        if (ratioWidth < 1.0) {
            double ratioMin = Math.min(ratioWidth, ratioHeight);
            width = Math.max(minWidth, (int)((double)picWidth * ratioMin));
            height = Math.max(minHeight, (int)((double)picHeight * ratioMin));
        } else if (ratioWidth > 1.0) {
            double ratioMax = Math.max(ratioWidth, ratioHeight);
            width = Math.min(maxWidth, (int)((double)picWidth * ratioMax));
            height = Math.min(maxHeight, (int)((double)picHeight * ratioMax));
        }
        return new Point(width, height);
    }

    public static String getProperBytes(long bytes) {
        if (bytes < 1000L) {
            return String.format(Locale.US, "%dB", bytes);
        }
        if (bytes <= 1000000L) {
            return String.format(Locale.US, "%.1fKB", (double)bytes / 1000.0);
        }
        if (bytes <= 1000000000L) {
            return String.format(Locale.US, "%.1fMB", (double)bytes / 1000000.0);
        }
        return String.format(Locale.US, "%.1fGB", (double)bytes / 1.0E9);
    }

    public static float dpToPx(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return dp * ((float)metrics.densityDpi / 160.0f);
    }

    public static String getCount(int count, boolean emptyIfZero) {
        return Utils.getCount((long)count, emptyIfZero);
    }

    public static String getCount(long count, boolean emptyIfZero) {
        if (count <= 0L && emptyIfZero) {
            return "";
        }
        return count >= 1000L ? "999+" : String.valueOf(count);
    }

    public static Spanned getHtmlFormattedText(String text) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)text, (int)0);
        }
        return Html.fromHtml((String)text);
    }
}

