package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.handler.TextLinkClickListener;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.LinkedTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;

/**
 * Created by mika on 2016. 12. 8..
 */
public class ChatMessageHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener, TextLinkClickListener {
  Context context;

  View root, profileLayout, headView, contextView, messageView;
  CHTextView textTime;
  LinkedTextView text;
  LinearLayout contentLayout;
  View webPageLayout, fileLayout, uploadLayout;

  MaskableFrameLayout imageLayout;
  ImageView imageContent, imagePlaceholder, imageUploading;
  CHTextView textFileName, textFileInfo;
  ImageView imageIcon;
  CHTextView textWebTitle, textWebDescription;
  View progressUpload, imageUploadFailed;

  SendingMessageItem sendingMessageItem;
  Message message;

  OnMessageClickListener listener;

  public ChatMessageHolder(
      View itemView,
      final OnMessageClickListener listener) {
    super(itemView);

    this.context = itemView.getContext();
    this.listener = listener;

    root = itemView.findViewById(R.id.layout_message_root);
    profileLayout = itemView.findViewById(R.id.message_profile_layout);
    textTime =  itemView.findViewById(R.id.message_time);
    headView = itemView.findViewById(R.id.message_head);
    contextView = itemView.findViewById(R.id.message_context);
    messageView = itemView.findViewById(R.id.message_text_view);
    text = (LinkedTextView) itemView.findViewById(R.id.message_text);

    contentLayout = (LinearLayout) itemView.findViewById(R.id.layout_content);
    imageLayout = (MaskableFrameLayout) itemView.findViewById(R.id.content_image);
    webPageLayout = itemView.findViewById(R.id.content_webpage);
    fileLayout = itemView.findViewById(R.id.content_file);
    uploadLayout = itemView.findViewById(R.id.content_loading);

    imageContent = (ImageView) itemView.findViewById(R.id.image_chat);
    imagePlaceholder = (ImageView) itemView.findViewById(R.id.image_placeholder);

    textFileName =  itemView.findViewById(R.id.text_file_name);
    textFileInfo =  itemView.findViewById(R.id.text_file_info);
    imageIcon = (ImageView) itemView.findViewById(R.id.icon_file);

    textWebTitle =  itemView.findViewById(R.id.text_web_title);
    textWebDescription =  itemView.findViewById(R.id.text_web_description);

    imageUploading = (ImageView) itemView.findViewById(R.id.image_loading);
    progressUpload = itemView.findViewById(R.id.progress_upload);
    imageUploadFailed = itemView.findViewById(R.id.image_upload_failed);

    contentLayout.setVisibility(View.GONE);

    imageContent.setOnClickListener(this);
    webPageLayout.setOnClickListener(this);
    fileLayout.setOnClickListener(this);
    text.setOnTextLinkClickListener(this);
  }

  private void setImage(PreviewThumb previewThumb, boolean webPage, String message) {
    int width = 0, height = 0;

    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    Point windowSize = new Point();
    wm.getDefaultDisplay().getSize(windowSize);

    if (webPage) {
      // 146 = margins' sum.
      width = windowSize.x - (int) Utils.dpToPx(context, 146);
      height = (int) (width * 0.52);
    } else {
      Point size = Utils.getCorrectImageSize(
          windowSize.x,
          windowSize.y,
          previewThumb.getWidth(),
          previewThumb.getHeight());
      width = Math.max(size.x, 1);
      height = Math.max(size.y, 1);
    }

    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) imageLayout.getLayoutParams();
    params.width = width;
    params.height = height;

    int marginTop = (int) Utils.dpToPx(context, !TextUtils.isEmpty(message) ? 10f : 0f);
    int marginBottom = (int) Utils.dpToPx(context, 4f);
    params.setMargins(0, marginTop, 0, marginBottom);

    imageLayout.setLayoutParams(params);
    imageLayout.setVisibility(View.VISIBLE);
    imagePlaceholder.setVisibility(View.VISIBLE);

    Glide.with(itemView.getContext())
        .load(previewThumb.getUrl())
        .asBitmap()
        .override(width, height)
        .dontAnimate()
        .centerCrop()
        .listener(new RequestListener<String, Bitmap>() {
          @Override
          public boolean onException(
              Exception e,
              String model,
              Target<Bitmap> target,
              boolean isFirstResource) {
            return false;
          }

          @Override
          public boolean onResourceReady(
              Bitmap resource,
              String model,
              Target<Bitmap> target,
              boolean isFromMemoryCache,
              boolean isFirstResource) {
            imagePlaceholder.setVisibility(View.GONE);
            return false;
          }
        })
        .into(imageContent);
  }

  protected void setLayout(boolean isContext, Long time) {
    profileLayout.setVisibility(UIUtils.getVisible(!isContext, true));
    headView.setVisibility(UIUtils.getVisible(!isContext, true));
    contextView.setVisibility(UIUtils.getVisible(isContext, true));
    textTime.setVisibility(UIUtils.getVisible(time != null, true));
  }

  public void set(Message message, boolean isContext) {
    this.sendingMessageItem = null;
    this.message = message;

    if (message == null) {
      return;
    }

    setLayout(isContext, message.getCreatedAt());

    textTime.setText(TimeUtils.getTime(message.getCreatedAt()));

    if (message.getMessage() != null) {
      messageView.setVisibility(View.VISIBLE);
      setText(message.getMessage());
    } else {
      messageView.setVisibility(View.GONE);
    }

    if (!message.hasContent()) {
      contentLayout.setVisibility(View.GONE);
    } else {
      contentLayout.setVisibility(View.VISIBLE);
      for (int i = 0; i < contentLayout.getChildCount(); i++) {
        contentLayout.getChildAt(i).setVisibility(View.GONE);
      }

      if (message.getFile() != null) {
        File file = message.getFile();
        if (file != null) {
          if (file.isImage() && file.getPreviewThumb() != null) {
            setImage(file.getPreviewThumb(), false, message.getMessage());
          } else {
            String fileSize = Utils.getProperBytes(file.getSize());
            String fileType = "";
            String extension = file.getExtension();

            if (!"default".equals(extension) && !TextUtils.isEmpty(extension)) {
              fileType = String.format(
                  " · %s",
                  extension.substring(0, 1).toUpperCase() + extension.substring(1));
            }

            textFileName.setText(file.getFilename());
            textFileInfo.setText(String.format("%s%s", fileSize, fileType));
            imageIcon.setImageResource(ResUtils.getFileIconResourceId(file));
            fileLayout.setVisibility(View.VISIBLE);
          }
        }
      } else if (message.getWebPage() != null) {
        WebPage webPage = message.getWebPage();
        setText(message.getMessage());
        if (webPage != null) {
          webPageLayout.setVisibility(View.VISIBLE);
          if (webPage.getPreviewThumb() != null) {
            setImage(webPage.getPreviewThumb(), true, message.getMessage());
          }

          if (!TextUtils.isEmpty(webPage.getTitle())) {
            textWebTitle.setText(webPage.getTitle());
          } else {
            textWebTitle.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
          }

          if (!TextUtils.isEmpty(webPage.getDescription())) {
            textWebDescription.setText(webPage.getTitle());
          } else {
            textWebDescription.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
          }
        }
      }
    }
  }

  protected void setText(String text) {
    this.text.setLinkedText(text == null ? "" : text);
  }

  @Override
  public void onClick(View v) {
    if (listener != null && message != null) {
      listener.messageClicked(message);
    }
  }

  @Override
  public void onTextLinkClick(View textView, String clickedString) {
    if (listener != null) {
      listener.urlClicked(clickedString);
    }
  }
}
