/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.deserializer;

import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.message_format.MessageParser;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.JsonDeserializationContext;
import com.zoyi.com.google.gson.JsonDeserializer;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class MessageDeserializer
implements JsonDeserializer {
    private Gson gson = new Gson();
    private MessageParser messageParser = MessageParser.create();

    public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Message message = (Message)this.gson.fromJson(json, type);
        if (message != null && message.getMessage() != null) {
            SpannableStringBuilder formattedMessage = this.messageParser.parse(message.getMessage());
            String formattedStringMessage = formattedMessage.toString();
            message.setFormattedSpanMessage(formattedMessage);
            message.setFormattedStringMessage(formattedStringMessage);
        }
        return message;
    }
}

