package com.zoyi.channel.plugin.android.view.layout;

import android.animation.Animator;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;

import com.zoyi.channel.plugin.android.activity.chat.TopNavFragment;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimatorListener;

public class ChatRecyclerView extends RecyclerView {

  public static final int DIRECTION_SCROLLING_DOWN = -1;

  private TopNavFragment topNavFragment;
  private String backwardId = Const.MESSAGE_ID_MAX;
  private float firstY, lastDy = 0, diff = 0;
  private boolean handleScroll = false;
  private boolean scrolling = false;
  private boolean isAnimating = false;

  public ChatRecyclerView(Context context) {
    this(context, null);
  }

  public ChatRecyclerView(Context context, @Nullable AttributeSet attrs) {
    this(context, attrs, 0);
  }

  public ChatRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
    super(context, attrs, defStyle);
  }

  public void setTopNavFragment(TopNavFragment topNavFragment) {
    this.topNavFragment = topNavFragment;
  }

  public void setBackwardId(String backwardId) {
    this.backwardId = backwardId;
  }

  public boolean isScrolling() {
    return scrolling;
  }

  private boolean isTop() {
    return !canScrollVertically(DIRECTION_SCROLLING_DOWN) && TextUtils.isEmpty(backwardId);
  }

  @Override
  public boolean onTouchEvent(MotionEvent e) {
    final int TOP_NAV_HEIGHT = topNavFragment.getLayoutTopNav().getHeight();
    float dy;

    if (isAnimating) {
      return true;
    }

    switch (e.getActionMasked()) {
      case MotionEvent.ACTION_DOWN:
        scrolling = true;
        firstY = e.getRawY();
        lastDy = 0;
        handleScroll = false;
        break;

      case MotionEvent.ACTION_MOVE:
        dy = e.getRawY() - firstY;
        diff = dy - lastDy;
        lastDy = dy;
        handleScroll = false;

        if (isTop()) {
          float lastTopNavTranslationY = topNavFragment.getRoot().getTranslationY();
          float translationY = getTranslationY();
          float topNavTranslationY;

          if (diff > 0) {
            // Positive is scroll down
            if (lastTopNavTranslationY == 0) {
              setTranslationY(Math.min(translationY + diff, TOP_NAV_HEIGHT), false);
              return true;
            }
            topNavTranslationY = Math.min(0, lastTopNavTranslationY + diff);
          } else {
            // Negative is scroll up
            if (lastTopNavTranslationY == -TOP_NAV_HEIGHT) {
              return super.onTouchEvent(e);
            } else if (lastTopNavTranslationY == 0) {
              if (translationY == 0) {
                return super.onTouchEvent(e);
              } else if (translationY > 0 && translationY < TOP_NAV_HEIGHT) {
                setTranslationY(Math.max(translationY + diff, 0), false);
                return true;
              }
            }
            topNavTranslationY = Math.max(-TOP_NAV_HEIGHT, lastTopNavTranslationY + diff);
          }
          handleScroll = true;
          RxBus.post(new TopNavBus.TranslationY(topNavTranslationY));

          setTranslationY(topNavTranslationY + TOP_NAV_HEIGHT, false);
          return true;
        }
        break;

      case MotionEvent.ACTION_UP:
        if (handleScroll && isTop()) {
          float topNavY = topNavFragment.getRoot().getTranslationY();

          if (topNavY > -TOP_NAV_HEIGHT / 2) {
            // Positive is scroll down
            RxBus.post(new TopNavBus.Expand());

            setTranslationY(TOP_NAV_HEIGHT, true);
          } else {
            // Negative is scroll up
            RxBus.post(new TopNavBus.Collapse());

            setTranslationY(0, true);
          }
          return true;
        } else {
          scrolling = false;
        }
        break;
    }
    return super.onTouchEvent(e);
  }

  public void setTranslationY(float value, boolean animate) {
    final boolean expand = value > 0;

    if (animate) {
      isAnimating = true;
      scrolling = true;
      animate().translationY(value)
          .setListener(new SimpleAnimatorListener() {
            @Override
            public void onAnimationEnd(Animator animation) {
              RxBus.post(new TopNavBus.Change(expand));

              isAnimating = false;
              scrolling = false;
            }
          })
          .start();
    } else {
      RxBus.post(new TopNavBus.Change(expand));
      super.setTranslationY(value);
    }
  }
}
