package com.zoyi.channel.plugin.android;

import android.support.annotation.NonNull;

public class ChannelPluginSettings {
  private String pluginKey;
  private boolean debugMode;
  private boolean hideDefaultLauncher;
  private boolean enabledTrackDefaultEvent;
  private boolean hideDefaultInAppPush;

  public ChannelPluginSettings(@NonNull String pluginKey) {
    this.pluginKey = pluginKey;
    this.debugMode = false;
    this.hideDefaultLauncher = false;
    this.enabledTrackDefaultEvent = true;
    this.hideDefaultInAppPush = false;
  }

  public ChannelPluginSettings setDebugMode(boolean debug) {
    this.debugMode = debug;
    return this;
  }

  public ChannelPluginSettings setHideDefaultLauncher(boolean hideDefaultLauncher) {
    this.hideDefaultLauncher = hideDefaultLauncher;
    return this;
  }

  public ChannelPluginSettings setEnabledTrackDefaultEvent(boolean enabledTrackDefaultEvent) {
    this.enabledTrackDefaultEvent = enabledTrackDefaultEvent;
    return this;
  }

  public ChannelPluginSettings setHideDefaultInAppPush(boolean hideDefaultInAppPush) {
    this.hideDefaultInAppPush = hideDefaultInAppPush;
    return this;
  }

  public String getPluginKey() {
    return pluginKey;
  }

  public boolean isDebugMode() {
    return debugMode;
  }

  public boolean isHideDefaultLauncher() {
    return hideDefaultLauncher;
  }

  public boolean isEnabledTrackDefaultEvent() {
    return enabledTrackDefaultEvent;
  }

  public boolean isHideDefaultInAppPush() {
    return hideDefaultInAppPush;
  }
}
