/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.event.BadgeBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.wrapper.ChannelWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChannelStore {
    private static ChannelStore channelStore;
    private Application application;
    private String pluginKey;
    private Plugin plugin;
    private Channel channel;
    private User user;
    private Veil veil;
    private Bot bot;
    private int activityRunningCount = 0;
    private Subscription channelFetchSubscription;
    private Subscription socketSubscription;
    private List<ChannelPluginListener> listeners;

    static void create(Application application) {
        if (channelStore == null) {
            channelStore = new ChannelStore(application);
        }
    }

    private ChannelStore(Application application) {
        this.application = application;
        this.listeners = new ArrayList<ChannelPluginListener>();
    }

    public static void setPluginKey(String key) {
        if (channelStore != null) {
            ChannelStore.channelStore.pluginKey = key;
        }
    }

    static void bootPlugin(PluginWrapper pluginWrapper) {
        if (channelStore != null) {
            PrefSupervisor.setVeilId((Context)ChannelStore.channelStore.application, pluginWrapper.getVeilId());
            if (pluginWrapper.getUser() != null) {
                ChannelStore.channelStore.user = pluginWrapper.getUser();
            }
            ChannelStore.channelStore.plugin = pluginWrapper.getPlugin();
            ChannelStore.channelStore.channel = pluginWrapper.getChannel();
            ChannelStore.channelStore.veil = pluginWrapper.getVeil();
            channelStore.startReceiveSocket();
            channelStore.startFetchChannel();
        }
    }

    static void clear() {
        if (channelStore != null) {
            channelStore.stopFetchChannel();
            channelStore.stopReceiveSocket();
            ChannelStore.channelStore.plugin = null;
            ChannelStore.channelStore.channel = null;
            ChannelStore.channelStore.user = null;
            ChannelStore.channelStore.veil = null;
        }
    }

    static void fetchMe(final OnGuestUpdatedListener listener) {
        if (channelStore != null) {
            ChannelIO.getApi().getMe().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<GuestWrapper>(){

                @Override
                public void onNext(GuestWrapper guestWrapper) {
                    if (channelStore != null && guestWrapper != null) {
                        ChannelStore.setUserVeil(guestWrapper.getUser(), guestWrapper.getVeil());
                        if (listener != null) {
                            listener.onGuestUpdated();
                        }
                    }
                }
            });
        }
    }

    private void startReceiveSocket() {
        if (this.socketSubscription == null || this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription = RxBus.observable().onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

                public void call(Object o) {
                    if (o instanceof CommandBus) {
                        CommandBus commandBus = (CommandBus)o;
                        switch (commandBus.getCommand()) {
                            case READY: {
                                ChannelStore.fetchMe(null);
                            }
                        }
                    }
                    if (o instanceof BadgeBus) {
                        for (ChannelPluginListener listener : ChannelStore.this.listeners) {
                            if (listener == null) continue;
                            listener.onChangeBadge(((BadgeBus)o).getCount());
                        }
                    }
                    if (o instanceof PushBus) {
                        PushBus pushBus = (PushBus)o;
                        for (ChannelPluginListener listener : ChannelStore.this.listeners) {
                            if (listener == null) continue;
                            listener.onReceivePush(new PushEvent(pushBus));
                        }
                    }
                }
            });
        }
    }

    private void stopReceiveSocket() {
        if (this.socketSubscription != null && !this.socketSubscription.isUnsubscribed()) {
            this.socketSubscription.unsubscribe();
        }
    }

    private void startFetchChannel() {
        this.stopFetchChannel();
        this.channelFetchSubscription = Observable.interval((long)3L, (TimeUnit)TimeUnit.MINUTES).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                if (channelStore != null) {
                    channelStore.fetchChannel();
                }
            }
        });
    }

    private void stopFetchChannel() {
        if (this.channelFetchSubscription != null && !this.channelFetchSubscription.isUnsubscribed()) {
            this.channelFetchSubscription.unsubscribe();
        }
    }

    private void fetchChannel() {
        ChannelIO.getApi().getChannels().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<ChannelWrapper>(){

            @Override
            public void onNext(ChannelWrapper channelWrapper) {
                if (channelWrapper != null) {
                    ChannelStore.this.channel = channelWrapper.getChannel();
                }
            }
        });
    }

    public static void setChannel(Channel channel) {
        if (channelStore != null && channel != null) {
            ChannelStore.channelStore.channel = channel;
        }
    }

    public static Channel getChannel() {
        return channelStore != null ? ChannelStore.channelStore.channel : null;
    }

    public static User getUser() {
        return channelStore != null ? ChannelStore.channelStore.user : null;
    }

    public static Bot getBot() {
        return channelStore != null ? ChannelStore.channelStore.bot : null;
    }

    public static String getName() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null && !ChannelStore.channelStore.user.isGhost().booleanValue()) {
                return ChannelStore.channelStore.user.getName();
            }
            if (ChannelStore.channelStore.veil != null && !ChannelStore.channelStore.veil.isGhost()) {
                return ChannelStore.channelStore.veil.getName();
            }
        }
        return null;
    }

    public static String getMobileNumber() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getMobileNumber();
            }
            if (ChannelStore.channelStore.veil != null) {
                return ChannelStore.channelStore.veil.getMobileNumber();
            }
        }
        return null;
    }

    public static String getPersonType() {
        if (channelStore != null && ChannelStore.channelStore.user != null) {
            return "User";
        }
        return "Veil";
    }

    public static String getPersonId() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getId();
            }
            return PrefSupervisor.getVeilId((Context)ChannelStore.channelStore.application);
        }
        return null;
    }

    public static String getVeilId() {
        if (channelStore != null && ChannelStore.channelStore.application != null) {
            return PrefSupervisor.getVeilId((Context)ChannelStore.channelStore.application);
        }
        return null;
    }

    public static String getUserId() {
        if (channelStore != null && ChannelStore.channelStore.user != null) {
            return ChannelStore.channelStore.user.getId();
        }
        return null;
    }

    public static boolean isLauncherHidden() {
        if (channelStore == null || ChannelStore.channelStore.channel == null || ChannelStore.channelStore.plugin == null) {
            return true;
        }
        if (ChannelStore.channelStore.plugin.isHideButton().booleanValue()) {
            return true;
        }
        return !ChannelStore.channelStore.channel.isWorking() && "hidden".equals(ChannelStore.channelStore.channel.getAwayOption());
    }

    public static boolean isRequestGuestInfo() {
        return channelStore != null && ChannelStore.channelStore.channel != null && ChannelStore.channelStore.channel.isRequestGuestInfo();
    }

    public static boolean hasName() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.isGhost() == false;
            }
            if (ChannelStore.channelStore.veil != null) {
                return !ChannelStore.channelStore.veil.isGhost();
            }
        }
        return true;
    }

    public static void setUserVeil(User user, Veil veil) {
        if (channelStore != null) {
            if (user != null) {
                ChannelStore.channelStore.user = user;
            }
            if (veil != null) {
                ChannelStore.channelStore.veil = veil;
            }
            if (ChannelStore.channelStore.application != null) {
                CheckInPrefSupervisor.setName((Context)ChannelStore.channelStore.application, ChannelStore.getName());
                CheckInPrefSupervisor.setMobileNumber((Context)ChannelStore.channelStore.application, ChannelStore.getMobileNumber());
            }
            RxBus.post(new BadgeBus(ChannelStore.getCount()));
        }
    }

    public static void setBot(Bot bot) {
        if (channelStore != null && bot != null) {
            ChannelStore.channelStore.bot = bot;
        }
    }

    public static Plugin getPlugin() {
        if (channelStore != null) {
            return ChannelStore.channelStore.plugin;
        }
        return null;
    }

    public static String getPluginKey() {
        if (channelStore != null) {
            return ChannelStore.channelStore.pluginKey;
        }
        return null;
    }

    public static void increaseActivityRunnigCount() {
        if (channelStore != null) {
            ++ChannelStore.channelStore.activityRunningCount;
        }
    }

    public static void decreaseActivityRunnigCount() {
        if (channelStore != null) {
            --ChannelStore.channelStore.activityRunningCount;
        }
    }

    public static boolean isMainRunning() {
        return channelStore != null && ChannelStore.channelStore.activityRunningCount > 0;
    }

    static boolean isDataStored() {
        return channelStore != null && ChannelStore.channelStore.channel != null && ChannelStore.channelStore.plugin != null;
    }

    static int getCount() {
        if (channelStore != null) {
            if (ChannelStore.channelStore.user != null) {
                return ChannelStore.channelStore.user.getAlert();
            }
            if (ChannelStore.channelStore.veil != null) {
                return ChannelStore.channelStore.veil.getAlert();
            }
        }
        return 0;
    }

    @NonNull
    static List<ChannelPluginListener> getChannelPluginListeners() {
        if (channelStore == null) {
            return new ArrayList<ChannelPluginListener>();
        }
        return ChannelStore.channelStore.listeners;
    }

    static void addChannelPluginListener(ChannelPluginListener listener) {
        if (channelStore != null && ChannelStore.channelStore.listeners != null && listener != null) {
            ChannelStore.channelStore.listeners.add(listener);
        }
    }

    static void removeChannelPluginListener(ChannelPluginListener listener) {
        if (channelStore != null && ChannelStore.channelStore.listeners != null && listener != null) {
            ChannelStore.channelStore.listeners.remove(listener);
        }
    }
}

