package com.zoyi.channel.plugin.android.util.message_format;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.message_format.message.BoldMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.EmojiMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.ItalicMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.LinkMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import com.zoyi.channel.plugin.android.util.message_format.message.UnescapeMessage;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class MessageParser {

  private final String ESCAPE_CODE_PATTERN = "```";

  private static MessageParser messageParser;
  private List<MessagePattern> patterns;
  private int linkColor;

  public static MessageParser create() {
    if (messageParser == null) {
      messageParser = new MessageParser(ChannelIO.getAppContext());
    }
    return messageParser;
  }

  private MessageParser(Context context) {
    this.patterns = new ArrayList<>();
    this.linkColor = ContextCompat.getColor(context, R.color.ch_cobalt);

    /**
     * 패턴을 추가한 순서대로 파싱 필터를 적용하므로
     * 특별한 이유없이 순서를 바꾸지 말 것
     */
    patterns.add(new EscapeMessage());
    patterns.add(new BoldMessage());
    patterns.add(new ItalicMessage());
    patterns.add(new EmojiMessage(AssetUtils.getEmojiDictionary(context)));
    patterns.add(new LinkMessage(linkColor));
    patterns.add(new UnescapeMessage());
  }

  public SpannableStringBuilder parse(@NonNull String message) {
    String[] tokens = message.split(ESCAPE_CODE_PATTERN, -1);
    SpannableStringBuilder parsedMessage = new SpannableStringBuilder(message);
    int location = 0;

    for (int index = 0; index < tokens.length; index++) {
      int tokenLength = tokens[index].length();

      if ("".equals(tokens[index])) {
        continue;
      }

      SpannableStringBuilder spannableToken = parseString(tokens[index]);

      if (index % 2 == 0) {
        parsedMessage.replace(location, location + tokenLength, spannableToken);
        location += spannableToken.length();
      } else {
        if (index == tokens.length - 1) {
          parsedMessage.replace(
              location + ESCAPE_CODE_PATTERN.length(),
              location + ESCAPE_CODE_PATTERN.length() + tokenLength, spannableToken);
          location += spannableToken.length();
        } else {
          int start = location;
          int end = location + tokenLength;

          parsedMessage.delete(end + ESCAPE_CODE_PATTERN.length(), end + (ESCAPE_CODE_PATTERN.length() * 2));
          parsedMessage.delete(start, start + ESCAPE_CODE_PATTERN.length());
          location += tokenLength;
        }
      }
    }

    return parsedMessage;
  }

  public SpannableStringBuilder parseString(String message) {
    SpannableStringBuilder spannableString = new SpannableStringBuilder(message);
    for (MessagePattern messagePattern : patterns) {
      spannableString = messagePattern.parse(spannableString);
    }

    return spannableString;
  }
}
