/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.com.bumptech.glide.Glide;
import java.util.List;
import java.util.Locale;

public class TypingHolder
extends RecyclerView.ViewHolder {
    private AvatarLayout firstAvatar;
    private AvatarLayout secondAvatar;
    private AvatarLayout thirdAvatar;
    private TextView textCount;
    private ImageView imageTyping;
    private View root;
    private Context context;

    public static TypingHolder newInstance(ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View itemView = inflater.inflate(R.layout.ch_plugin_item_message_typing, parent, false);
        return new TypingHolder(itemView);
    }

    public TypingHolder(View itemView) {
        super(itemView);
        this.context = itemView.getContext();
        this.root = itemView.findViewById(R.id.ch_plugin_layout_typing_root);
        this.firstAvatar = (AvatarLayout)itemView.findViewById(R.id.ch_plugin_avatar_first);
        this.secondAvatar = (AvatarLayout)itemView.findViewById(R.id.ch_plugin_avatar_second);
        this.thirdAvatar = (AvatarLayout)itemView.findViewById(R.id.ch_plugin_avatar_third);
        this.textCount = (TextView)itemView.findViewById(R.id.ch_plugin_tv_person_count);
        this.imageTyping = (ImageView)itemView.findViewById(R.id.ch_plugin_iv_typing);
    }

    public void bind(TypingItem item) {
        if (item.hasTyping()) {
            this.root.setVisibility(0);
            ChatDataDictionary dictionary = ChatDataDictionary.getInstance();
            Glide.with(this.context).load(R.drawable.ch_plugin_typing).asGif().into(this.imageTyping);
            List<Typing> typings = item.getTypings();
            if (item.hasMoreThanFour()) {
                this.secondAvatar.setVisibility(0);
                this.thirdAvatar.setVisibility(8);
                this.textCount.setVisibility(0);
                this.firstAvatar.set(typings.get(0).getProfileEntity(dictionary));
                this.secondAvatar.set(typings.get(1).getProfileEntity(dictionary));
                this.textCount.setText((CharSequence)String.format(Locale.US, "+%d", typings.size() - 2));
            } else {
                this.textCount.setVisibility(8);
                int size = typings.size();
                if (size <= 0) {
                    return;
                }
                this.firstAvatar.set(typings.get(0).getProfileEntity(dictionary));
                switch (size) {
                    case 1: {
                        this.secondAvatar.setVisibility(8);
                        this.thirdAvatar.setVisibility(8);
                        break;
                    }
                    case 2: {
                        this.secondAvatar.set(typings.get(1).getProfileEntity(dictionary));
                        this.secondAvatar.setVisibility(0);
                        this.thirdAvatar.setVisibility(8);
                        break;
                    }
                    case 3: {
                        this.secondAvatar.set(typings.get(1).getProfileEntity(dictionary));
                        this.thirdAvatar.set(typings.get(2).getProfileEntity(dictionary));
                        this.secondAvatar.setVisibility(0);
                        this.thirdAvatar.setVisibility(0);
                    }
                }
            }
        } else {
            this.root.setVisibility(4);
        }
    }
}

