package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;

/**
 * Created by jerry on 2018. 1. 9..
 */

public class WaterMarkLayout extends RelativeLayout{
    private ImageView imageView;
    private TextView textView;

    public WaterMarkLayout(Context context) {
        super(context);
        initialize(context, null);
    }

    public WaterMarkLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize(context, attrs);
    }

    public WaterMarkLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize(context, attrs);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public WaterMarkLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        initialize(context, attrs);
    }

    public void initialize(Context context, AttributeSet attrs) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        inflater.inflate(R.layout.ch_plugin_layout_watermark, this);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        imageView = (ImageView) findViewById(R.id.watermark_image);
        textView = (TextView) findViewById(R.id.watermark_text);
    }
}
