package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.util.draw.Display;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Created by ryan on 2017. 8. 28..
 */

public class Event {

  private String name;
  private Map<String, Object> property;
  private Map<String, Object> sysProperty;

  public Event(
      @Nullable Context context,
      @NonNull String pluginKey,
      @NonNull String name,
      @Nullable Map<String, Object> property) {
    this.name = name;
    this.property = property;
    setSysProperty(context, pluginKey);
  }

  private void setSysProperty(Context context, String pluginKey) {
    sysProperty = new HashMap<>();
    if (!TextUtils.isEmpty(pluginKey)) {
      sysProperty.put("pluginId", pluginKey);
    }
    sysProperty.put("pluginVersion", BuildConfig.VERSION_NAME);
    sysProperty.put("screenWidth", Display.getWidth(context));
    sysProperty.put("screenHeight", Display.getHeight(context));
    sysProperty.put("os", String.format(Locale.US, "Android %d", Build.VERSION.SDK_INT));
    sysProperty.put("device", Build.MODEL);
  }
}
