/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Patterns;
import com.zoyi.channel.plugin.android.view.handler.TextLinkClickListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class LinkedTextView
extends TextView {
    private List<Hyperlink> listOfLinks;
    private TextLinkClickListener listener;
    private int linkTextColor;

    public LinkedTextView(Context context) {
        super(context);
        this.init();
    }

    public LinkedTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.listOfLinks = new ArrayList<Hyperlink>();
        this.linkTextColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ch_cobalt);
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public void setLinkColor(int linkTextColor) {
        this.linkTextColor = linkTextColor;
    }

    public void setLinkedText(String text) {
        this.listOfLinks.clear();
        SpannableString linkableText = new SpannableString((CharSequence)text);
        this.gatherLinks(this.listOfLinks, (Spannable)linkableText);
        for (Hyperlink listOfLink : this.listOfLinks) {
            try {
                linkableText.setSpan((Object)listOfLink.span, listOfLink.start, listOfLink.end, 33);
            }
            catch (Exception exception) {}
        }
        this.setText((CharSequence)linkableText);
    }

    public void setOnTextLinkClickListener(TextLinkClickListener listener) {
        this.listener = listener;
    }

    private void gatherLinks(List<Hyperlink> links, Spannable s) {
        Matcher m = Patterns.WEB_URL.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            Hyperlink spec = new Hyperlink();
            spec.span = new InternalURLSpan(s.subSequence(start, end).toString());
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private class Hyperlink {
        InternalURLSpan span;
        int start;
        int end;

        private Hyperlink() {
        }
    }

    private class InternalURLSpan
    extends ClickableSpan {
        private String string;

        InternalURLSpan(String string2) {
            this.string = string2;
        }

        public void onClick(View textView) {
            if (LinkedTextView.this.listener != null && this.string != null) {
                LinkedTextView.this.listener.onTextLinkClick(textView, this.string.trim());
            }
        }

        public void updateDrawState(@NonNull TextPaint textPaint) {
            try {
                textPaint.setColor(LinkedTextView.this.linkTextColor);
                textPaint.setUnderlineText(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

