/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigBar
extends LinearLayout {
    private static final int MENU_BUTTON_WIDTH = 40;
    private static final int MENU_TEXT_WIDTH = 32;
    private static final int TITLE_LAYOUT_MARGIN = 16;
    RelativeLayout layout;
    LinearLayout leftLayout;
    LinearLayout rightLayout;
    TextView textTitle;
    TextView textSubTitle;
    ImageView imageLeftOfTitle;
    ImageView imageRightOfTitle;
    ConstraintLayout titleLayout;
    FrameLayout layoutAlert;
    TextView textAlert;
    private Context context;
    private BaseActivity activity;
    private Animation pushAnimation;
    private Animation alertAnimation;
    private boolean titleSelectable = false;
    private Map<Integer, TextView> textMap;
    private List<MenuButton> buttons;
    private int background = -16777216;
    private int foreground = -1;
    private boolean init = false;

    public BigBar(Context context) {
        super(context);
        this.init(context);
    }

    public BigBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BigBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public BigBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_bigbar, (ViewGroup)this, true);
        this.layout = (RelativeLayout)this.findViewById(R.id.bar_layout);
        this.leftLayout = (LinearLayout)this.findViewById(R.id.layout_left);
        this.rightLayout = (LinearLayout)this.findViewById(R.id.layout_right);
        this.textTitle = (TextView)this.findViewById(R.id.bar_title_main);
        this.textSubTitle = (TextView)this.findViewById(R.id.bar_sub_title);
        this.imageLeftOfTitle = (ImageView)this.findViewById(R.id.iv_title_left);
        this.imageRightOfTitle = (ImageView)this.findViewById(R.id.iv_title_right);
        this.titleLayout = (ConstraintLayout)this.findViewById(R.id.layout_title);
        this.textMap = new HashMap<Integer, TextView>();
        this.buttons = new ArrayList<MenuButton>();
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_push);
        this.pushAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.alertAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_alert);
        this.alertAnimation.setFillEnabled(true);
        this.alertAnimation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
                BigBar.this.layoutAlert.setVisibility(0);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                BigBar.this.hideAlert();
            }
        });
    }

    public BigBar withActivity(BaseActivity activity) {
        this.activity = activity;
        return this;
    }

    public BigBar addMenu(MenuButton.ActionType actionType, MenuPosition menuPosition) {
        return this.addMenu(actionType, menuPosition, MenuButton.MenuState.VISIBLE);
    }

    public BigBar addMenu(final MenuButton.ActionType actionType, MenuPosition menuPosition, MenuButton.MenuState menuState) {
        MenuButton menuButton = new MenuButton(this.context);
        menuButton.setAction(actionType);
        menuButton.setMenuPosition(menuPosition);
        menuButton.setOnTouchListener(new ButtonTouchHandler((View)menuButton));
        menuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BigBar.this.eventRaised(actionType);
            }
        });
        this.setViewState((View)menuButton, menuState);
        this.addView((View)menuButton, menuPosition);
        this.buttons.add(menuButton);
        return this;
    }

    public BigBar addText(MenuPosition menuPosition) {
        return this.addText(0, menuPosition, "");
    }

    public BigBar addText(MenuPosition menuPosition, String string2) {
        return this.addText(0, menuPosition, string2);
    }

    private BigBar addText(int id2, MenuPosition menuPosition, String string2) {
        if (!this.textMap.containsKey(id2)) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)Utils.dpToPx(this.context, 32.0f), -2);
            params.weight = 1.0f;
            params.leftMargin = MenuPosition.LEFT.equals((Object)menuPosition) ? (int)Utils.dpToPx(this.context, 8.0f) * -1 : 0;
            params.rightMargin = MenuPosition.RIGHT.equals((Object)menuPosition) ? (int)Utils.dpToPx(this.context, 8.0f) * -1 : 0;
            params.gravity = 0x10 | (MenuPosition.LEFT.equals((Object)menuPosition) ? 0x800003 : 0x800005);
            TextView textView = new TextView(this.context);
            textView.setTypeface(textView.getTypeface(), 1);
            textView.setTextSize(2, 14.0f);
            textView.setLayoutParams((ViewGroup.LayoutParams)params);
            textView.setText((CharSequence)string2);
            this.textMap.put(id2, textView);
            this.addView((View)textView, menuPosition);
        }
        return this;
    }

    public void setText(int number) {
        if (this.textMap.size() == 1) {
            this.setText(this.textMap.entrySet().iterator().next().getKey(), number);
        }
    }

    public void setText(int id2, int number) {
        if (this.textMap.containsKey(id2)) {
            this.textMap.get(id2).setText((CharSequence)Utils.getCount(number, true));
        }
    }

    public void setMenuState(MenuButton.ActionType actionType, MenuButton.MenuState buttonState) {
        if (actionType == null) {
            return;
        }
        for (MenuButton menuButton : this.buttons) {
            if (!actionType.equals((Object)menuButton.getAction())) continue;
            this.setViewState((View)menuButton, buttonState);
        }
    }

    public BigBar setTitle(String string2) {
        this.textTitle.setText((CharSequence)string2);
        return this;
    }

    public BigBar setSubTitle(String subTitle) {
        if (!TextUtils.isEmpty((CharSequence)subTitle)) {
            this.textSubTitle.setText((CharSequence)subTitle);
        }
        return this;
    }

    public BigBar setSubTitleVisibility(boolean visible) {
        this.textSubTitle.setVisibility(UIUtils.getVisible(visible, true));
        return this;
    }

    public void setImageLeftOfTitle(@DrawableRes int resId) {
        if (resId == 0) {
            this.imageLeftOfTitle.setVisibility(8);
        } else {
            this.imageLeftOfTitle.setImageResource(resId);
            this.imageLeftOfTitle.setVisibility(0);
        }
    }

    public void setImageRightOfTitle(@DrawableRes int resId) {
        if (resId == 0) {
            this.imageRightOfTitle.setVisibility(8);
        } else {
            this.imageRightOfTitle.setImageResource(resId);
            this.imageRightOfTitle.setVisibility(0);
        }
    }

    public View getImageLeftOfTitle() {
        return this.imageLeftOfTitle;
    }

    public View getImageRightOfTitle() {
        return this.imageRightOfTitle;
    }

    public BigBar setTheme(@ColorInt int background, @ColorInt int foreground) {
        this.background = background;
        this.foreground = foreground;
        this.layout.setBackgroundColor(background);
        this.textTitle.setTextColor(foreground);
        this.textSubTitle.setTextColor(foreground == -1 ? ContextCompat.getColor((Context)this.context, (int)R.color.ch_white) : ContextCompat.getColor((Context)this.context, (int)R.color.ch_charcoal_grey));
        for (TextView textView : this.textMap.values()) {
            textView.setTextColor(foreground);
        }
        for (MenuButton menuButton : this.buttons) {
            menuButton.setColor(foreground);
        }
        return this;
    }

    public boolean isTitleSelectable() {
        return this.titleSelectable;
    }

    public void hide() {
        this.layout.setVisibility(8);
    }

    public void build() {
        if (this.init) {
            return;
        }
        this.init = true;
        if ((this.foreground < 0 || this.background < 0) && this.activity != null) {
            this.background = this.activity.getBackgroundColor();
            this.foreground = this.activity.getTextColor();
        }
        this.setTheme(this.background, this.foreground);
        this.setTitleLayoutMargin();
    }

    private void setViewState(View view, MenuButton.MenuState menuState) {
        if (menuState == null) {
            return;
        }
        switch (menuState) {
            case VISIBLE: {
                view.setVisibility(0);
                view.setAlpha(1.0f);
                view.setEnabled(true);
                break;
            }
            case DISABLED: {
                view.setVisibility(0);
                view.setAlpha(0.3f);
                view.setEnabled(false);
                break;
            }
            case HIDDEN: {
                view.setVisibility(8);
            }
        }
        this.setTitleLayoutMargin();
    }

    private int getMarginForTitle() {
        int left = 16;
        int right = 16;
        if (this.textMap.size() > 0) {
            left += 32;
        }
        for (MenuButton button : this.buttons) {
            switch (button.getMenuPosition()) {
                case LEFT: {
                    if (!button.isVisible()) break;
                    left += 40;
                    break;
                }
                case RIGHT: {
                    if (!button.isVisible()) break;
                    right += 40;
                }
            }
        }
        return (int)Math.max(Utils.dpToPx(this.context, left), Utils.dpToPx(this.context, right));
    }

    private void setTitleLayoutMargin() {
        int margin = this.getMarginForTitle();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.titleLayout.getLayoutParams();
        layoutParams.leftMargin = margin;
        layoutParams.rightMargin = margin;
        this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addView(View view, MenuPosition menuPosition) {
        if (MenuPosition.LEFT.equals((Object)menuPosition)) {
            this.leftLayout.addView(view);
        } else {
            this.rightLayout.addView(view);
        }
    }

    private void eventRaised(MenuButton.ActionType actionType) {
        if (this.activity != null) {
            this.activity.optionClicked(actionType);
        }
    }

    public void showAlert(String message) {
        if (message != null) {
            this.textAlert.setText((CharSequence)message);
            this.layoutAlert.startAnimation(this.alertAnimation);
        }
    }

    public void hideAlert() {
        this.layoutAlert.clearAnimation();
        this.layoutAlert.setVisibility(8);
    }

    public class ButtonTouchHandler
    implements View.OnTouchListener {
        private float normal = 1.0f;
        private float pressed = 0.3f;

        public ButtonTouchHandler(View view) {
            view.setAlpha(this.normal);
        }

        public ButtonTouchHandler(View view, float normal, float pressed) {
            this.normal = normal;
            this.pressed = pressed;
            view.setAlpha(normal);
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (v.isEnabled()) {
                switch (event.getAction()) {
                    case 0: {
                        v.setAlpha(this.pressed);
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.setAlpha(this.normal);
                    }
                }
            }
            return false;
        }
    }

    public static enum MenuPosition {
        LEFT,
        RIGHT;

    }
}

