/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.socket;

import android.app.Application;
import android.content.Context;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TypingBus;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Log;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.rest.Veil;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.io.socket.client.IO;
import com.zoyi.io.socket.client.Socket;
import com.zoyi.io.socket.client.SocketIOException;
import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.engineio.client.EngineIOException;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketManager {
    private static SocketManager socketManager;
    private Application application;
    private Socket socket;
    private Gson gson;
    private Timer heartbeatTimer;
    private Timer reconnectConsumer;
    private AtomicBoolean forceDisconnect;
    private AtomicBoolean ready;
    private AtomicBoolean error;
    private Subscription heartbeat;
    private BlockingQueue<Integer> reconnectQueue;
    private int[] attemptDelay = new int[]{100, 3000, 4000, 5000, 7000, 8000, 10000};
    private AtomicInteger attemptCount = new AtomicInteger();
    private static final int HEARTBEAT_INTERVAL = 30000;
    private static final int RECONNECT_POP_INTERVAL = 500;
    static String SOCKET_END_POINT;
    private String channelId;
    private Emitter.Listener onTyping = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onTyping: " + objects[0].toString());
            Typing typing = (Typing)SocketManager.this.parseJson(objects[0].toString(), Typing.class);
            if (typing != null) {
                typing.setCreatedAt(System.currentTimeMillis());
                RxBus.post(new TypingBus(typing));
            }
        }
    };
    private Emitter.Listener onConnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnect: ");
            try {
                SocketManager.this.error.set(false);
                SocketManager.this.forceDisconnect.set(false);
                SocketManager.this.attemptCount.set(0);
                SocketManager.this.authentication();
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
            RxBus.post(new CommandBus(Command.SOCKET_CONNECTED));
        }
    };
    private Emitter.Listener onConnectTimeout = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnectTimeout");
        }
    };
    private Emitter.Listener onConnectError = new Emitter.Listener(){

        public void call(Object ... objects) {
            SocketManager.this.ready.set(false);
            SocketManager.this.enqueueReconnect();
            SocketManager.this.error.set(true);
            RxBus.post(new CommandBus(Command.SOCKET_DISCONNECTED, SocketManager.this.forceDisconnect.get()));
            RxBus.post(new CommandBus(Command.SOCKET_ERROR));
            try {
                EngineIOException exception;
                String message = "";
                if (objects[0] instanceof EngineIOException) {
                    exception = (EngineIOException)objects[0];
                    message = exception.getMessage();
                }
                if (objects[0] instanceof SocketIOException) {
                    exception = (SocketIOException)objects[0];
                    message = exception.getMessage();
                }
                L.e("onConnectError: " + message);
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onConnecting = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnecting");
        }
    };
    private Emitter.Listener onDisconnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onDisconnect: " + objects[0] + " " + SocketManager.this.forceDisconnect.get());
            SocketManager.this.ready.set(false);
            SocketManager.this.stopHeartbeat();
            RxBus.post(new CommandBus(Command.SOCKET_DISCONNECTED, SocketManager.this.forceDisconnect.get()));
            if (!SocketManager.this.forceDisconnect.get()) {
                SocketManager.this.enqueueReconnect();
            }
        }
    };
    private Emitter.Listener onError = new Emitter.Listener(){

        public void call(Object ... objects) {
            EngineIOException exception = (EngineIOException)objects[0];
            L.e("onError: " + objects.length + " " + exception.getMessage());
            SocketManager.this.error.set(true);
            RxBus.post(new CommandBus(Command.SOCKET_ERROR));
            SocketManager.this.ready.set(false);
            SocketManager.this.enqueueReconnect();
        }
    };
    private Emitter.Listener onPing = new Emitter.Listener(){

        public void call(Object ... objects) {
        }
    };
    private Emitter.Listener onPong = new Emitter.Listener(){

        public void call(Object ... objects) {
        }
    };
    private Emitter.Listener onReconnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onReconnect: " + (Integer)objects[0]);
        }
    };
    private Emitter.Listener onReconnectAttempt = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onReconnectAttempt: " + (Integer)objects[0]);
        }
    };
    private Emitter.Listener onReconnectError = new Emitter.Listener(){

        public void call(Object ... objects) {
            SocketIOException exception = (SocketIOException)objects[0];
            L.e("onReconnectError: " + exception.getMessage());
            SocketManager.this.enqueueReconnect();
            SocketManager.this.ready.set(false);
            RxBus.post(new CommandBus(Command.SOCKET_DISCONNECTED, SocketManager.this.forceDisconnect.get()));
        }
    };
    private Emitter.Listener onReconnectFailed = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.e("onReconnectFailed");
            SocketManager.this.enqueueReconnect();
            SocketManager.this.ready.set(false);
            RxBus.post(new CommandBus(Command.SOCKET_DISCONNECTED, SocketManager.this.forceDisconnect.get()));
        }
    };
    private Emitter.Listener onReconnecting = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onReconnecting: " + (Integer)objects[0]);
            RxBus.post(new CommandBus(Command.SOCKET_RECONNECTING));
        }
    };
    private Emitter.Listener onAuthenticated = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onAuthenticated: " + objects[0]);
        }
    };
    private Emitter.Listener onReady = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("Ready");
            SocketManager.this.ready.set(true);
            SocketManager.this.startHeartbeat();
            SocketManager.this.clearReconnectQueue();
            RxBus.post(new CommandBus(Command.READY));
        }
    };
    private Emitter.Listener onJoined = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onJoined: " + objects[0]);
            try {
                String[] split = StringUtils.split((String)objects[0], '/');
                RxBus.post(new CommandBus(Command.JOINED, split[1]));
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onLeaved = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onLeaved: " + objects[0]);
            try {
                String[] split = StringUtils.split((String)objects[0], '/');
                RxBus.post(new CommandBus(Command.LEAVED, split[1]));
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onUnauthorized = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.e("onUnauthorized: " + objects[0].toString());
            SocketManager.this.ready.set(false);
            SocketManager.this.forceDisconnect.set(true);
            SocketManager.this.socket.disconnect();
            RxBus.post(new CommandBus(Command.UNAUTHORIZED));
        }
    };
    private Emitter.Listener onPush = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onPush: " + objects[0].toString());
            try {
                JSONObject json = (JSONObject)objects[0];
                UserChat userChat = null;
                ProfileEntity person = null;
                String type = json.getString("type");
                if (json.has("refers")) {
                    JSONObject refers = json.getJSONObject("refers");
                    if (refers.has("bot")) {
                        person = (ProfileEntity)SocketManager.this.parseJson(refers.getString("bot"), Bot.class);
                    }
                    if (refers.has("manager")) {
                        person = (ProfileEntity)SocketManager.this.parseJson(refers.getString("manager"), Manager.class);
                    }
                    if (refers.has("userChat")) {
                        userChat = (UserChat)SocketManager.this.parseJson(refers.getString("userChat"), UserChat.class);
                    }
                }
                switch (type) {
                    case "Message": {
                        Log log;
                        Message message = (Message)SocketManager.this.parseJson(json.getString("entity"), Message.class);
                        if (message == null) break;
                        String string2 = null;
                        if (message.getMessage() != null) {
                            string2 = message.getMessage();
                        } else if (message.getFile() != null) {
                            string2 = message.getFile().isImage() ? ResUtils.getString((Context)SocketManager.this.application, "ch.notification.upload_image.description") : ResUtils.getString((Context)SocketManager.this.application, "ch.notification.upload_file.description");
                        } else if (message.getLog() != null && "resolve".equals((log = message.getLog()).getAction())) {
                            string2 = ResUtils.getString((Context)SocketManager.this.application, "ch.review.require.preview");
                        }
                        if (string2 == null) break;
                        RxBus.post(new PushBus(string2, person, userChat));
                    }
                }
            }
            catch (Exception e) {
                L.e(e.getMessage());
            }
        }
    };
    private Emitter.Listener onCreate = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("+ onCreate) " + SocketManager.this.getTag((JSONObject)objects[0]) + objects[0].toString());
            SocketManager.this.onMessage((JSONObject)objects[0], true);
        }
    };
    private Emitter.Listener onUpdate = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("~ onUpdate) " + SocketManager.this.getTag((JSONObject)objects[0]) + objects[0].toString());
            SocketManager.this.onMessage((JSONObject)objects[0], true);
        }
    };
    private Emitter.Listener onDelete = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("- onDelete) " + SocketManager.this.getTag((JSONObject)objects[0]) + objects[0].toString());
            SocketManager.this.onMessage((JSONObject)objects[0], false);
        }
    };

    public static void create(Application application) {
        if (socketManager == null) {
            socketManager = new SocketManager();
            SocketManager.socketManager.application = application;
            socketManager.init();
        }
    }

    private void init() {
        this.gson = new Gson();
        this.forceDisconnect = new AtomicBoolean(false);
        this.ready = new AtomicBoolean(false);
        this.error = new AtomicBoolean(false);
        this.reconnectQueue = new ArrayBlockingQueue<Integer>(1);
        try {
            IO.Options options = new IO.Options();
            options.reconnection = false;
            options.transports = new String[]{"websocket"};
            this.socket = IO.socket((String)SOCKET_END_POINT, (IO.Options)options);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket.on("connect", this.onConnect);
        this.socket.on("connect_error", this.onConnectError);
        this.socket.on("connect_timeout", this.onConnectTimeout);
        this.socket.on("connecting", this.onConnecting);
        this.socket.on("disconnect", this.onDisconnect);
        this.socket.on("error", this.onError);
        this.socket.on("ping", this.onPing);
        this.socket.on("pong", this.onPong);
        this.socket.on("reconnect", this.onReconnect);
        this.socket.on("reconnect_attempt", this.onReconnectAttempt);
        this.socket.on("reconnect_error", this.onReconnectError);
        this.socket.on("reconnect_failed", this.onReconnectFailed);
        this.socket.on("reconnecting", this.onReconnecting);
        this.socket.on("authenticated", this.onAuthenticated);
        this.socket.on("ready", this.onReady);
        this.socket.on("create", this.onCreate);
        this.socket.on("delete", this.onDelete);
        this.socket.on("joined", this.onJoined);
        this.socket.on("leaved", this.onLeaved);
        this.socket.on("push", this.onPush);
        this.socket.on("unauthorized", this.onUnauthorized);
        this.socket.on("update", this.onUpdate);
        this.socket.on("typing", this.onTyping);
    }

    public static void setChannelId(String channelId) {
        if (socketManager != null) {
            SocketManager.socketManager.channelId = channelId;
        }
    }

    public static boolean isReady() {
        if (socketManager != null) {
            return SocketManager.socketManager.ready.get();
        }
        return false;
    }

    public static boolean isError() {
        if (socketManager != null) {
            return SocketManager.socketManager.error.get();
        }
        return false;
    }

    public static void connect() {
        if (socketManager != null) {
            socketManager.connectSocket();
        }
    }

    public static void reconnect() {
        if (socketManager != null && ChannelStore.isMainRunning()) {
            socketManager.enqueueReconnect();
        }
    }

    public static void joinChat(String chatId) {
        if (socketManager != null) {
            socketManager.chatAction("join", chatId);
        }
    }

    public static void leaveChat(String chatId) {
        if (socketManager != null) {
            socketManager.chatAction("leave", chatId);
        }
    }

    public static void typing(Typing typing) {
        try {
            if (socketManager != null) {
                socketManager.emit("typing", new JSONObject(new Gson().toJson((Object)typing)));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void disconnect() {
        if (socketManager != null) {
            socketManager.disconnect(true);
            socketManager.stopHeartbeat();
        }
    }

    public static void destroy() {
        if (socketManager != null) {
            socketManager.setReconnectConsumer(false);
            SocketManager.socketManager.socket.off();
            SocketManager.socketManager.socket.disconnect();
            SocketManager.socketManager.channelId = null;
            SocketManager.socketManager.forceDisconnect = null;
            SocketManager.socketManager.ready = null;
            SocketManager.socketManager.reconnectQueue = null;
            SocketManager.socketManager.socket = null;
            SocketManager.socketManager.gson = null;
            socketManager = null;
        }
    }

    private void enqueueReconnect() {
        if (!this.ready.get()) {
            try {
                this.reconnectQueue.add(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearReconnectQueue() {
        try {
            this.reconnectQueue.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connectSocket() {
        if (this.socket != null && !this.socket.connected() && this.channelId != null) {
            L.d("try connect");
            this.socket.connect();
            this.setReconnectConsumer(true);
        }
    }

    private void disconnect(boolean force) {
        this.forceDisconnect.set(force);
        try {
            this.clearReconnectQueue();
            this.socket.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!force) {
            this.enqueueReconnect();
        } else {
            this.setReconnectConsumer(false);
        }
    }

    private void authentication() {
        String personType = ChannelStore.getPersonType();
        String personId = ChannelStore.getPersonId();
        if (personType != null && personId != null && this.channelId != null) {
            String info = String.format("{\n  type: \"Plugin\",\n  channelId: \"%s\",\n  guestType: \"%s\",\n  guestId: \"%s\"}", this.channelId, personType, personId);
            try {
                JSONObject jsonObject = new JSONObject(info);
                this.emit("authentication", jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
                RxBus.post(new CommandBus(Command.UNAUTHORIZED));
            }
        } else {
            this.disconnect(true);
        }
    }

    private synchronized void setReconnectConsumer(boolean flag) {
        if (flag) {
            if (this.reconnectConsumer == null) {
                this.reconnectConsumer = new Timer();
                this.reconnectConsumer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Integer data = (Integer)SocketManager.this.reconnectQueue.peek();
                            if (data != null) {
                                int index = Math.min(SocketManager.this.attemptCount.getAndIncrement(), SocketManager.this.attemptDelay.length - 1);
                                Thread.sleep(SocketManager.this.attemptDelay[index]);
                                SocketManager.this.reconnectQueue.remove();
                                SocketManager.this.connectSocket();
                            }
                        }
                        catch (Exception e) {
                            L.e(e.getMessage());
                        }
                    }
                }, 500L, 500L);
            }
        } else if (this.reconnectConsumer != null) {
            try {
                this.reconnectConsumer.cancel();
            }
            catch (Exception exception) {
            }
            finally {
                this.reconnectConsumer = null;
            }
        }
    }

    private void startHeartbeat() {
        this.stopHeartbeat();
        this.heartbeat = Observable.interval((long)30000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                try {
                    SocketManager.this.socket.emit("heartbeat", new Object[]{""});
                }
                catch (Exception ex) {
                    L.e("socket error");
                }
            }
        });
    }

    private synchronized void stopHeartbeat() {
        if (this.heartbeat != null && !this.heartbeat.isUnsubscribed()) {
            this.heartbeat.unsubscribe();
        }
    }

    private void emit(String event, Object object) {
        if (object == null || this.socket == null) {
            return;
        }
        this.socket.emit(event, new Object[]{object});
    }

    private void chatAction(String action, String chatId) {
        if (this.socket == null) {
            return;
        }
        if (chatId == null || !this.ready.get()) {
            return;
        }
        String message = String.format("/user_chats/%s", chatId);
        this.emit(action, message);
    }

    private String getTag(JSONObject json) {
        try {
            String type = json.getString("type");
            String id2 = json.getJSONObject("entity").getString("id");
            return String.format("%s (%s): ", type, id2);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private void onMessage(JSONObject json, boolean upsert) {
        try {
            String type;
            if (!json.has("type") || !json.has("entity")) {
                return;
            }
            String entity = json.getString("entity");
            switch (type = json.getString("type")) {
                case "Manager": {
                    Manager manager = this.parseJson(entity, Manager.class);
                    if (manager == null) {
                        return;
                    }
                    RxBus.post(new ChannelModelBus(manager, upsert));
                    break;
                }
                case "Message": {
                    Message message = this.parseJson(entity, Message.class);
                    if (message == null) {
                        return;
                    }
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("file")) {
                            File fileRefers = this.parseJson(refers.getString("file"), File.class);
                            RxBus.post(new ChannelModelBus(fileRefers, upsert));
                        }
                        if (refers.has("webPage")) {
                            WebPage webPageRefers = this.parseJson(refers.getString("webPage"), WebPage.class);
                            RxBus.post(new ChannelModelBus(webPageRefers, upsert));
                        }
                        if (refers.has("bot")) {
                            Bot botRefers = this.parseJson(refers.getString("bot"), Bot.class);
                            RxBus.post(new ChannelModelBus(botRefers, upsert));
                        }
                    }
                    RxBus.post(new ChannelModelBus(message, upsert));
                    break;
                }
                case "UserChat": {
                    UserChat userChat = this.parseJson(entity, UserChat.class);
                    if (userChat == null) {
                        return;
                    }
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("message")) {
                            Message referMessage = this.parseJson(refers.getString("message"), Message.class);
                            RxBus.post(new ChannelModelBus(referMessage, upsert));
                        }
                        if (refers.has("manager")) {
                            Manager referManager = this.parseJson(refers.getString("manager"), Manager.class);
                            RxBus.post(new ChannelModelBus(referManager, upsert));
                        }
                        if (refers.has("bot")) {
                            Bot referBot = this.parseJson(refers.getString("bot"), Bot.class);
                            RxBus.post(new ChannelModelBus(referBot, upsert));
                        }
                    }
                    RxBus.post(new ChannelModelBus(userChat, upsert));
                    break;
                }
                case "Session": {
                    Session session = this.parseJson(entity, Session.class);
                    if (session == null) {
                        return;
                    }
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("bot")) {
                            Bot referBot = this.parseJson(refers.getString("bot"), Bot.class);
                            RxBus.post(new ChannelModelBus(referBot, upsert));
                        }
                        if (refers.has("manager")) {
                            Manager referManager = this.parseJson(refers.getString("manager"), Manager.class);
                            RxBus.post(new ChannelModelBus(referManager, upsert));
                        }
                    }
                    RxBus.post(new ChannelModelBus(session, upsert));
                    break;
                }
                case "File": {
                    File file = this.parseJson(entity, File.class);
                    if (file == null) break;
                    RxBus.post(new ChannelModelBus(file, upsert));
                    break;
                }
                case "Channel": {
                    Channel channel = this.parseJson(entity, Channel.class);
                    if (channel == null) break;
                    ChannelStore.setChannel(channel);
                    RxBus.post(new ChannelModelBus(channel, upsert));
                    break;
                }
                case "Veil": {
                    Veil veil = this.parseJson(entity, Veil.class);
                    if (veil == null) break;
                    ChannelStore.setUserVeil(null, veil);
                    break;
                }
                case "User": {
                    User user = this.parseJson(entity, User.class);
                    if (user == null) break;
                    ChannelStore.setUserVeil(user, null);
                }
            }
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }

    private <T> T parseJson(String entity, Class<T> target) {
        if (entity == null) {
            return null;
        }
        try {
            return (T)ParseUtils.getCustomGson().fromJson(entity, target);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        SOCKET_END_POINT = "https://ws.channel.io/app";
    }
}

