/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ImageMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;

public class WebMessageHolder
extends ImageMessageHolder
implements View.OnClickListener {
    RelativeLayout webPageLayout;
    TextView webTitleText;
    TextView webDescriptionText;
    private OnMessageClickListener listener;
    private Message message;

    public static WebMessageHolder newInstance(ViewGroup parent, MessageType messageType, OnMessageClickListener listener) {
        return new WebMessageHolder(WebMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public WebMessageHolder(View itemView, MessageType messageType, OnMessageClickListener listener) {
        super(itemView, messageType, listener);
        this.listener = listener;
        this.webPageLayout = (RelativeLayout)itemView.findViewById(R.id.ch_message_content_webpage);
        this.webTitleText = (TextView)itemView.findViewById(R.id.text_web_title);
        this.webDescriptionText = (TextView)itemView.findViewById(R.id.text_web_description);
    }

    @Override
    public void bind(ChatMessageItem item, boolean isConnectedMessage) {
        WebPage webPage;
        super.bind(item, isConnectedMessage);
        this.message = item.getMessage();
        if (this.message != null && (webPage = this.message.getWebPage()) != null) {
            if (MessageType.GUEST_WEB_MESSAGE == item.getType()) {
                this.guestMessageTextLayout.setVisibility(0);
            } else {
                this.managerMessageTextLayout.setVisibility(0);
            }
            this.setWebMessage(webPage, this.message.getMessage());
        }
    }

    private void setWebMessage(WebPage webPage, String messageText) {
        this.webPageLayout.setVisibility(0);
        this.webPageLayout.setOnClickListener((View.OnClickListener)this);
        if (webPage.getPreviewThumb() != null) {
            super.setImageMessage(webPage.getPreviewThumb(), true, messageText);
            if (this.getPreviewSize() != null) {
                int width = this.getPreviewSize().x;
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
                this.webPageLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)webPage.getTitle())) {
            this.webTitleText.setText((CharSequence)webPage.getTitle());
        } else {
            this.webTitleText.setText((CharSequence)(webPage.getUrl() != null ? webPage.getUrl() : ""));
        }
        if (!TextUtils.isEmpty((CharSequence)webPage.getDescription())) {
            this.webDescriptionText.setText((CharSequence)webPage.getTitle());
        } else {
            this.webDescriptionText.setText((CharSequence)(webPage.getUrl() != null ? webPage.getUrl() : ""));
        }
    }

    @Override
    public void onClick(View v) {
        if (this.message != null) {
            this.listener.messageClicked(this.message);
        }
    }
}

