package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.graphics.Color;

import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Channel implements ProfileEntity {

  public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
  public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
  public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";

  private String id;
  private String name;
  private String description;
  private String country;
  private Long createdAt;
  private String domain;
  private String color;
  private String textColor;
  private String userInfoUrl;
  private String timeZone;
  private WorkingTime workingTime;
  private TimeRange lunchTime;
  private String homepageUrl;
  private String phoneNumber;
  private String servicePlan;
  private Boolean serviceBlocked;
  private Boolean requestGuestInfo;
  private String expectedResponseDelay;
  private String workingType;
  private String awayOption;
  private String initial;
  private Boolean trial;
  private String avatarUrl;
  private String trialExpiryDate;
  private Boolean outOfWorkPlugin;
  private Boolean working;

  public String getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getCountry() {
    return country;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public String getDomain() {
    return domain;
  }

  public String getColor() {
    return color;
  }

  public String getUserInfoUrl() {
    return userInfoUrl;
  }

  public String getTimeZone() {
    return timeZone;
  }

  public String getAwayOption() {
    return awayOption;
  }

  public String getWorkingType() {
    return workingType;
  }

  @Override
  public String getPersonType() {
    return this.getClass().getSimpleName();
  }

  @Override
  public int getBackgroundColor() {
    try {
      return Color.parseColor(color);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @Override
  public int getTextColor() {
    return "black".equals(textColor) ? Color.BLACK : Color.WHITE;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Override
  public String getInitial() {
    return initial;
  }

  public boolean isWorking() {
    return working;
  }

  public final static String CLASSNAME = "Channel";

  public String getWorkingTime(Context context) {
    String launch = lunchTime != null
      ? String.format(
          "%s: %s",
          ResUtils.getString(context, "ch.out_of_work.lunch_time"),
          TimeUtils.getTimeRangeString(lunchTime))
      : null;

    if (workingTime != null) {
      String work = workingTime.getMessage(context);
      if (launch != null) {
        return String.format("Timezone: %s<br><br>%s<br><br>%s", timeZone, work, launch);
      }
      return String.format("Timezone: %s<br><br>%s", timeZone, work);
    }
    return "";
  }

  public String getHomepageUrl() {
    return homepageUrl;
  }

  public String getPhoneNumber() {
    return phoneNumber;
  }

  public boolean isRequestGuestInfo() {
    return requestGuestInfo;
  }

  public String getExpectedResponseDelay() {
    return expectedResponseDelay;
  }

  public String getServicePlan() {
    return servicePlan;
  }

  public Boolean getServiceBlocked() {
    return serviceBlocked;
  }

  public Boolean isTrial() {
    if (trial == null) {
      return false;
    }
    return trial;
  }

  public String getTrialExpiryDate() {
    return trialExpiryDate;
  }

  public boolean isBlockedPlugin() {
    return (isFreePlan() && !isTrial()) || serviceBlocked;
  }

  public boolean isFreePlan() {
    return "free".equals(getServicePlan());
  }
}
