package com.zoyi.channel.plugin.android.activity.chat;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class PreviewFragment extends Fragment implements View.OnClickListener {

  private View root;
  private AvatarLayout avatarPreview;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_chat_preview, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    root = view;
    root.setOnClickListener(this);

    avatarPreview = (AvatarLayout) view.findViewById(R.id.layout_avatar_preview);
    avatarPreview.setTextSize(12);
  }

  @Override
  public void onClick(View v) {
    if (getActivity() instanceof ChatActivity) {
      hide();
      ((ChatActivity) getActivity()).scrollToBottom(true);
    }
  }

  public void show(ProfileEntity profileEntity) {
    avatarPreview.set(profileEntity);
    root.setVisibility(View.VISIBLE);
  }

  public void hide() {
    root.setVisibility(View.GONE);
  }
}
