/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatHolder;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract;
import java.util.HashMap;
import java.util.Map;

class UserChatListAdapter
extends RecyclerView.Adapter<UserChatHolder>
implements UserChatAdapterContract.View,
UserChatAdapterContract.Model {
    private OnUserChatClickListener clickListener;
    private Map<String, UserChatItem> map = new HashMap<String, UserChatItem>();
    private SortedList<UserChatItem> items = new SortedList(UserChatItem.class, new SortedListCallback(this, true));
    private boolean refreshBySocket = false;

    UserChatListAdapter() {
    }

    @Override
    public void setOnUserChatClickListener(OnUserChatClickListener clickListener) {
        this.clickListener = clickListener;
    }

    @Override
    public void removeUserChat(String chatId) {
        if (this.map.containsKey(chatId)) {
            this.items.remove((Object)this.map.get(chatId));
        }
    }

    @Override
    public void clear() {
        if (this.map != null) {
            this.map.clear();
        }
        if (this.items != null) {
            this.items.clear();
        }
    }

    @Override
    public void init(UserChatsWrapper wrapper) {
        UserChatListDataDictionary dictionary = UserChatListDataDictionary.getInstance();
        for (UserChat userChat : wrapper.getUserChats()) {
            if (TextUtils.isEmpty((CharSequence)userChat.getLastMessageId())) continue;
            UserChatItem item = new UserChatItem(userChat, dictionary);
            this.map.put(item.getId(), item);
            this.items.add((Object)item);
        }
        this.refreshBySocket = true;
    }

    @Override
    public void stopRefreshBySocket() {
        this.refreshBySocket = false;
    }

    public String getChatId(int position) {
        if (this.items.size() <= position) {
            return null;
        }
        return ((UserChatItem)this.items.get(position)).getUserChat().getId();
    }

    @Override
    public void removeItem(UserChat userChat) {
        int position;
        String chatId;
        if (this.refreshBySocket && userChat != null && this.map.containsKey(chatId = userChat.getId()) && (position = this.items.indexOf((Object)this.map.get(chatId))) >= 0) {
            this.map.remove(chatId);
            this.items.removeItemAt(position);
        }
    }

    @Override
    public void updateItem(UserChatItem item) {
        int position;
        if (this.refreshBySocket && (position = this.items.indexOf((Object)item)) >= 0) {
            this.items.updateItemAt(position, (Object)item);
        }
    }

    @Override
    public void addOrUpdateItem(UserChat userChat) {
        if (this.refreshBySocket && userChat != null) {
            UserChatListDataDictionary dictionary = UserChatListDataDictionary.getInstance();
            String chatId = userChat.getId();
            if (this.map.containsKey(chatId)) {
                UserChatItem item = this.map.get(chatId);
                item.setUserChat(userChat);
                this.updateItem(item);
            } else {
                UserChatItem item = new UserChatItem(userChat, dictionary);
                this.map.put(item.getId(), item);
                this.items.add((Object)item);
            }
        }
    }

    public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return UserChatHolder.newInstance(parent, this.clickListener);
    }

    public void onBindViewHolder(UserChatHolder holder, int position) {
        holder.setUserChatItem((UserChatItem)this.items.get(position));
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void updateManager(String managerId) {
        if (this.refreshBySocket) {
            for (int i = 0; i < this.items.size(); ++i) {
                UserChatItem item = (UserChatItem)this.items.get(i);
                if (!managerId.equals(item.getUserChat().getHostId())) continue;
                this.items.updateItemAt(i, (Object)item);
            }
        }
    }

    @Override
    public void updateSession(Session session) {
        if (this.refreshBySocket && session != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                UserChatItem item = (UserChatItem)this.items.get(i);
                if (!item.getSessionId().equals(session.getId())) continue;
                item.setSession(session);
                this.items.updateItemAt(i, (Object)item);
                break;
            }
        }
    }
}

